/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.component;


import java.util.ArrayList;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer.Designer;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DiagramLayout;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.DiagramView;
import com.google.gwt.user.client.ui.Widget;


public abstract class DiagramComponent {
	
	private Designer designer;
	private String name;
	private String positionName;
	private int positionOrder;
	private DiagramLayout diagramLayout;
	
	private DiagramComponentHelper helper;
	
	private String title;
	
	private ArrayList<DiagramView> viewsDisplayedOn = new ArrayList<DiagramView>();
	
	public DiagramComponent(String name) {
		this.name = name;
		
		this.helper = new DiagramComponentHelper(this);
		
	}
	
	public String getName(){
		return this.name;
	}
	
	
	public DiagramLayout getDiagramLayout() {
		return diagramLayout;
	}
	
	public void setDiagramLayout(DiagramLayout diagramLayout) {
		this.diagramLayout = diagramLayout;
	}
	
	public String getTitle() {
		return title;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getPositionName(){
		return this.positionName;
	}
	
	public void displayInPosition(String positionName) {
		this.positionName = positionName;
	}
	
	public int getPositionOrder(){
		return this.positionOrder;
	}

	public void setDesigner(Designer designer) {
		this.designer = designer;
	}
	
	
	public void displayOnView(DiagramView view){
		this.viewsDisplayedOn.add(view);
		this.designer.getRegistry().addView(view);
	}
	
	public boolean isDisplayableOnView(DiagramView view){
		
		return this.viewsDisplayedOn.contains(view);
	}
	
	
	public DiagramComponentHelper getHelper() {
		return helper;
	}
	
	public Designer getDesigner() {
		return designer;
	}
	
	public ArrayList<DiagramView> getViewsDisplayedOn() {
		return viewsDisplayedOn;
	}
	
	public abstract Widget getComponent();

}
