/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.component;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanelTab;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModel;
import com.google.gwt.user.client.ui.Widget;

public class DiagramComponentHelper {
	
	private DiagramComponent diagramComponent;
	
	
	public DiagramComponentHelper(DiagramComponent component) {
		this.diagramComponent 	= component;
	}
	
	
	public DiagramModel getCurrentDiagramModel(){
		return diagramComponent.getDesigner().getRegistry().getLayout().getDrawingPanelTab().getCurrentDrawingPanel().getDiagramModel();
	}
	
	public DrawingPanel getCurrentDiagramDrawingPanel(){
		return diagramComponent.getDesigner().getRegistry().getLayout().getDrawingPanelTab().getCurrentDrawingPanel();
	}
	
	public DiagramComponent getComponentByName(String name){
		return diagramComponent.getDesigner().getRegistry().getComponentByName(name);
	}
	
	public DrawingPanelTab getDrawingPanelTab(){
		return diagramComponent.getDesigner().getRegistry().getLayout().getDrawingPanelTab();
	}
	
	public void replaceComponentWidget(DiagramComponent component,Widget widget){
		diagramComponent.getDesigner().getRegistry().getLayout().replaceComponentWidget(component, widget);
	}
	
	
}
