/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.component;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.CollapseExpandEvent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.CollapseExpandHandler;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.HasCollapseExpandHandlers;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.CollapseExpandEvent.Operation;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.gwtext.client.widgets.BoxComponent;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Container;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.PanelListener;

/**
 * A DiagramPanel is just a Panel wrapped to fit in GWT 2.0 event style.
 * It publish some new events when a collapse/expand occurs
 * @author enhan
 *
 */
public class DiagramComponentPanel extends Panel implements PanelListener, HasCollapseExpandHandlers, HasResizeHandlers{

	
	
	public DiagramComponentPanel() {
		addListener(this);
	}
	
	public HandlerRegistration addCollapseExpandHandler(CollapseExpandHandler handler){
		return addHandler(handler, CollapseExpandEvent.getType());
	}

	public boolean doBeforeClose(Panel panel) {
		return true;
	}

	public boolean doBeforeCollapse(Panel panel, boolean animate) {
		return true;
	}

	public boolean doBeforeExpand(Panel panel, boolean animate) {
		return true;
	}

	public void onActivate(Panel panel) {}

	public void onBodyResize(Panel panel, String width, String height) {
		ResizeEvent.fire(this, Integer.parseInt(width), Integer.parseInt(height));
	}

	public void onClose(Panel panel) {}

	public void onCollapse(Panel panel) {
		CollapseExpandEvent.fire(this, Operation.COLLAPSE);
	}

	public void onDeactivate(Panel panel) {}

	public void onExpand(Panel panel) {
		CollapseExpandEvent.fire(this, Operation.EXPAND);
	}

	public void onTitleChange(Panel panel, String title) {}

	public boolean doBeforeAdd(Container self, Component component, int index) {
		return true;
	}

	public boolean doBeforeRemove(Container self, Component component) {
		return true;
	}

	public void onAdd(Container self, Component component, int index) {}

	public void onAfterLayout(Container self) {}

	public void onRemove(Container self, Component component) {}

	public void onMove(BoxComponent component, int x, int y) {}

	public void onResize(BoxComponent component, int adjWidth, int adjHeight,
			int rawWidth, int rawHeight) {
		
		ResizeEvent.fire(this, rawWidth, rawHeight);
		
	}

	public boolean doBeforeDestroy(Component component) {
		return true;
	}

	public boolean doBeforeHide(Component component) {
		return true;
	}

	public boolean doBeforeRender(Component component) {
		return true;
	}

	public boolean doBeforeShow(Component component) {
		return true;
	}

	public boolean doBeforeStateRestore(Component component,
			JavaScriptObject state) {
		return true;
	}

	public boolean doBeforeStateSave(Component component, JavaScriptObject state) {
		return true;
	}

	public void onDestroy(Component component) {
	}

	public void onDisable(Component component) {}

	public void onEnable(Component component) {}

	public void onHide(Component component) {}

	public void onRender(Component component) {}

	public void onShow(Component component) {}

	public void onStateRestore(Component component, JavaScriptObject state) {}

	public void onStateSave(Component component, JavaScriptObject state) {}

	public HandlerRegistration addResizeHandler(ResizeHandler arg0) {
		return addHandler(arg0, ResizeEvent.getType());
	}

	

}
