/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.component;

import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntax;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.renderer.DiagramRenderer;
import com.google.gwt.user.client.ui.Widget;

public class DrawingPanelComponent extends DiagramComponent{
	
	private String name;
	
	private SyntaxModel model;
	
	private DiagramSyntax syntax;

	private DiagramRenderer diagramRenderer;
	
	public DrawingPanelComponent(String name,DiagramSyntax syntax,DiagramRenderer diagramRenderer) {
		super(name);
		
		this.name				= name;
		this.syntax 			= syntax;
		this.diagramRenderer 	= diagramRenderer;
		
		this.diagramRenderer.setDrawingPanelComponent(this);
		
	}	

	public SyntaxModel getModel() {
		return model;
	}
	
	
	public DiagramRenderer getDiagramRenderer() {
		return diagramRenderer;
	}
	
	/**
	 * The component gets the model when it is invoked
	 * @param model
	 */
	public void setModel(SyntaxModel model) {
		this.model = model;
	}
	
	/**
	 * Should return a drawingPanel
	 */
	@Override
	public Widget getComponent() {
		return diagramRenderer.render(model);
	}
	
	public DiagramSyntax getSyntax() {
		return syntax;
	}
	
	
}
