/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.component;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DesignerListener;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DesignerListenerAdapter;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.AllView;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.DiagramView;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.ToolbarMenuButton;
import com.gwtext.client.widgets.ToolbarTextItem;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;

public class MenuComponent extends DiagramComponent{

	private Toolbar toolBar;
	
	private boolean designerIsLoaded=false;
	
	public MenuComponent(String name) {
		super(name);
		
		this.toolBar = new Toolbar();
		
	}
	
	public void addButton(ToolbarButton button){
		this.toolBar.addButton(button);
	}
	
	
	
	public void addMenuButton(ToolbarMenuButton menuButton){
		this.toolBar.addButton(menuButton);
	}
	
	public void addSeparator(){
		this.toolBar.addSeparator();
	}
	
	public void addFill(){
		this.toolBar.addFill();
	}
	
	/**
	 * Displays a menu to switch within all the views that were <br>
	 * registered.
	 * 
	 * @param parentPanel
	 */
	public void displayViewMenu(){

		if (designerIsLoaded){
			addViewMenu();
		}else{
			
			
			getDesigner().addDesignerListener(new DesignerListenerAdapter(){
				
				public void onLoad() {
					
					designerIsLoaded = true;
					addViewMenu();
				}
				
			});
			
			
		}
		

		
		
	}
	
	

	
	
	private void addViewMenu(){
		
		for(final DiagramView view: getDesigner().getRegistry().getViews().values()){
			
			if (!view.equals(new AllView())){
				
				ToolbarButton button = new ToolbarButton(view.getName());
				button.setToggleGroup("view");
				
				if (view.equals(getDiagramLayout().getCurrentView())){
					button.setPressed(true);
				}
				
				toolBar.addButton(button);
				
				
				button.addListener(new ButtonListenerAdapter(){
					
					@Override
					public void onClick(Button button, EventObject e) {
						
						getDiagramLayout().switchToView(view);
						
						super.onClick(button, e);
					}
					
				});
			}

			
		}
		
	}
	
	
	@Override
	public Widget getComponent() {
		return toolBar;
	}

	public void addItem(ToolbarTextItem item) {
		this.toolBar.addItem(item);
	}

}
