/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.component;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntax;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.renderer.PaletteRenderer;
import com.google.gwt.user.client.ui.Widget;


public class PaletteComponent extends DiagramComponent {

	private DiagramSyntax 	syntax;
	private PaletteRenderer renderer;

	public PaletteComponent(String name,DiagramSyntax syntax,PaletteRenderer renderer) {
		super(name);
		
		this.syntax 	= syntax;
		this.renderer 	= renderer;
		
		this.renderer.setPaletteComponent(this);
	}

	public PaletteComponent(String name,DiagramSyntax syntax) {
		super(name);
		
		this.syntax 	= syntax;
		
		this.renderer 	= new PaletteRenderer();
		this.renderer.setPaletteComponent(this);
		
	}
	
	public DiagramSyntax getSyntax() {
		return syntax;
	}
	
	public PaletteRenderer getRenderer() {
		return renderer;
	}


	@Override
	public Widget getComponent() {
		return renderer.render(syntax);
	}
	

}
