/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.component;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.renderer.PropertyRenderer;
import com.google.gwt.user.client.ui.Widget;

public class PropertyComponent extends DiagramComponent {

	private DiagramModel diagramModel;
	private PropertyRenderer renderer;

	public PropertyComponent(String name,PropertyRenderer renderer) {
		super(name);
		
		this.renderer 		= renderer;

		
	}
	
	public PropertyComponent(String name){
		super(name);
		
		this.renderer		= new PropertyRenderer();
	}
	
	
	public void setDiagramModel(DiagramModel diagramModel) {
		this.diagramModel = diagramModel;
	}
	
	public DiagramModel getDiagramModel() {
		return diagramModel;
	}
	
	@Override
	public Widget getComponent() {
		return this.renderer.render(diagramModel);
	}

}
