/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer;

import java.util.ArrayList;

import com.allen_sauer.gwt.log.client.Log;
import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DiagramComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DrawingPanelComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntax;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DesignerListener;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DefaultLayout;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DiagramLayout;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.DiagramView;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.gwtext.client.widgets.Panel;


/**
 * 
 * @author nfleury
 *
 */
public class Designer extends Panel{
	
	private Registry registry;
	
	private ArrayList<DesignerListener> listeners = new ArrayList<DesignerListener>();
	
	private DesignerController controller;
	
	
	public Designer() {
		
		this.registry = new Registry(this);

		Log.setUncaughtExceptionHandler();
		
		this.controller = new DesignerController(this);
		
		DesignerProxyHelper.designer = this;
	}
	
	public void setDefaultView(DiagramView defaultView) {
		this.getRegistry().getLayout().setCurrentView(defaultView);
	}
	
	public DiagramView getDefaultView() {
		return this.getRegistry().getLayout().getCurrentView();
	}
	
	public Registry getRegistry(){
		return this.registry;
	}
	
	public void setLayout(DiagramLayout layout){
		this.registry.setLayout(layout); 
	}
	
	public DiagramLayout getDiagramLayout(){
		return this.registry.getLayout();
	}
	
	
	public void registerComponent(DiagramComponent component){
		this.registry.addComponent(component);
	}
	
	
	public void loadDiagram(DiagramSyntax syntax,SyntaxModel model){
		
		DrawingPanelComponent drawingPanelComponent = this.registry.getDrawingPanelComponentBySyntax(syntax);

		drawingPanelComponent.setModel(model);
		
		DrawingPanel drawingPanel = (DrawingPanel) drawingPanelComponent.getComponent(); 
		

		this.registry.getLayout().getDrawingPanelTab().addDrawingPanel(drawingPanel);
		this.registry.getLayout().getDrawingPanelTab().doLayout();
		
		//trigger the onLoadDiagram event
		for(DesignerListener listener:listeners){
			listener.onLoadDiagram(syntax, model, drawingPanel);
		}
		
		//collapse the property grid
		DefaultLayout dl = (DefaultLayout)this.getDiagramLayout();
		dl.getSouthPanel().expand();
	}
	

	public ArrayList<DesignerListener> getListeners() {
		return listeners;
	}

	
	public void addDesignerListener(DesignerListener listener){
		this.listeners.add(listener);
	}
	
	
	public DesignerController getController() {
		return controller;
	}
	
	@Override
	protected void onLoad() {
		
		Designer.this.add(Designer.this.registry.getLayout());
		Designer.this.registry.getLayout().initGUI();		


		//trigger "onLoad event"
		for(DesignerListener listener:listeners){
			listener.onLoad();
		}
		
		Designer.this.getController().unmask();
		
			

		
		super.onLoad();

	}
	
	


}
