/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;


import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DiagramComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DrawingPanelComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntax;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DefaultLayout;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DiagramLayout;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.DiagramView;
import com.google.gwt.core.client.GWT;

/**
 * The registry is used to register every <br>
 * component needed by the editor.
 * 
 * @author nfleury
 *
 */
public class Registry {
	
	private HashMap<String,DiagramComponent> components 							= new HashMap<String,DiagramComponent>();
	
	private DiagramLayout layout	;
	
	private HashMap<String,DiagramSyntax> syntaxes									= new HashMap<String,DiagramSyntax>();
	
	private HashMap<String,DiagramView> views										= new HashMap<String,DiagramView>();
	
	private HashMap<DiagramSyntax, DrawingPanelComponent> drawingPanelComponents 	= new HashMap<DiagramSyntax, DrawingPanelComponent>();

	private Designer designer;
	
	public Registry(Designer designer) {
			
		this.designer 	= designer;
		
		this.layout 	= new DefaultLayout();
		
		this.layout.setDesigner(designer);
		
	}
	
	
	public DiagramView getViewByName(String name){
		return this.views.get(name);
	}
	
	public HashMap<String, DiagramView> getViews() {
		return views;
	}
	
	public DiagramSyntax getDiagramSyntaxByName(String name){
		return this.syntaxes.get(name);
	}

	
	public DiagramComponent getComponentByName(String name){
		return this.components.get(name);
	}
	
	
	public void addView(DiagramView view){
		this.views.put(view.getName(),view);
	}
	
	public void addSyntax(DiagramSyntax syntax){
		this.syntaxes.put(syntax.getName(),syntax);
	}
	
	public void addComponent(DiagramComponent component){
		
		component.setDesigner(designer);
		
		this.components.put(component.getName(), component);

		if (component instanceof DrawingPanelComponent){
			
			DrawingPanelComponent dpc = (DrawingPanelComponent) component;

			drawingPanelComponents.put(dpc.getSyntax(), dpc);
			
		}
		
	}
	
	
	public ArrayList<DiagramComponent> getComponentByPosition(String positionName){
		
		Iterator it = components.keySet().iterator(); 
		
		ArrayList<DiagramComponent> result = new ArrayList<DiagramComponent>();
		
		while(it.hasNext()) { 
			
			Object key = it.next();
			
			DiagramComponent component = components.get(key);
			
			if (component.getPositionName() != null){
		
				if (component.getPositionName().equals(positionName)){
					result.add(component);
				}
			}
		
		} 
		
		
		return result;
	
	}
	
	
	public DrawingPanelComponent getDrawingPanelComponentBySyntax(DiagramSyntax syntax){

		return drawingPanelComponents.get(syntax);
	}
	
	
	
	public void setLayout(DiagramLayout layout) {
		this.layout = layout;
		this.layout.setDesigner(designer);
	}
	
	
	public DiagramLayout getLayout() {
		return layout;
	}
	

	
	
	
	
}
