/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DiagramElementTypeInstantiationHandler;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;

public abstract class DiagramPaletteElementType extends DiagramElementType implements DDPaletteElement, DiagramElementTypeInstantiationHandler{

	private DefaultStringPropertyHandler stringHandler;
	private DefaultBooleanPropertyHandler booleanHandler;
	
	public DiagramPaletteElementType(String name) {
		super(name);
		addInstantiationHandler(this);
		stringHandler = new DefaultStringPropertyHandler();
		booleanHandler = new DefaultBooleanPropertyHandler();
		
	}

	public void onInstantiation(DiagramElementInstance instance) {
		// handle string properties
		for(DiagramProperty<String> property : instance.getElementModel().getPropertiesForType(String.class)){
			property.addValueChangeHandler(stringHandler);
		}
		
		for (DiagramProperty<Boolean> property : instance.getElementModel().getPropertiesForType(Boolean.class)) {
			property.addValueChangeHandler(booleanHandler);
		}
	}

	protected void onStringPropertyChange(DiagramProperty<String> property,
			String newValue) {
		
	}

	protected void onBooleanPropertyChange(DiagramProperty<Boolean> property,
			Boolean newValue) {
		
	}

	
	private class DefaultStringPropertyHandler implements ValueChangeHandler<String>{

		@SuppressWarnings("unchecked")
		public void onValueChange(ValueChangeEvent<String> event) {
			DiagramProperty<String> source = (DiagramProperty<String>) event.getSource();
			onStringPropertyChange(source, event.getValue());			
		}
		
	}
	
	private class DefaultBooleanPropertyHandler implements ValueChangeHandler<Boolean>{
		@SuppressWarnings("unchecked")
		public void onValueChange(ValueChangeEvent<Boolean> event) {
			DiagramProperty<Boolean> source = (DiagramProperty<Boolean>) event.getSource();
			onBooleanPropertyChange(source, event.getValue());
		}
	}

	
}
