/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.helper;

import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.common.WebDesignerConstants;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer.Designer;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.StdAsyncCallback;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.WebDesignerService;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.WebDesignerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.DoNotRunWith;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * 
 * @author nfleury
 *
 */
public class ModelToFileDownloader {
	
	private static Frame downloadFrame;

	private String syntaxName;
	private String version;
	private String fileToDownloadFormat;
	private SyntaxModel model;
	private Designer designer;
	
	private WebDesignerServiceAsync designerService = (WebDesignerServiceAsync) GWT.create(WebDesignerService.class);

	
	
	public ModelToFileDownloader(SyntaxModel model,String syntaxName,String version,String fileToDownloadFormat,Designer designer) {
	
		this.syntaxName 			= syntaxName;
		this.version 				= version;
		this.fileToDownloadFormat 	= fileToDownloadFormat;
		this.model					= model;
		
		this.designer 				= designer;
		
	}
	
	
	public void downloadFile(){
		
		designer.getController().mask("Creating file, please wait ...");
		
		this.designerService.createFileFromModel(model, syntaxName, version, fileToDownloadFormat, new StdAsyncCallback<String>(){
			@Override
			public void onSuccess(String fileUrl) {
				
				//once the file has been generated, download it
				fileUrl = GWT.getModuleBaseURL() + WebDesignerConstants.ServiceURL.downloader + "?url=" + fileUrl  ;
				
				displayDownloadFrame(fileUrl);
				
				designer.getController().unmask();
			}
			
			@Override
			public void onFailure(Throwable arg0) {
				
				designer.getController().unmask();
				super.onFailure(arg0);
			}
			
		});
		
	}
	
	
	private void displayDownloadFrame(String url){
		if(downloadFrame==null){
			downloadFrame = new Frame(url);
			RootPanel.get().add(downloadFrame);
		}
		else{
			downloadFrame.setUrl(url);
			downloadFrame.setVisible(true);


		}
	}
	
}
