/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DiagramComponentPanel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.CollapseExpandEvent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.CollapseExpandHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HTML;
import com.gwtext.client.core.Margins;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Viewport;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.widgets.layout.FitLayout;

/**
 * 
 * @author nfleury
 *
 */
public class DefaultLayout extends DiagramLayout implements ResizeHandler, CollapseExpandHandler{
	
	
	private DiagramComponentPanel westPanel;
	private DiagramComponentPanel southPanel;
	private DiagramComponentPanel northPanel;
	private DiagramComponentPanel centerPanel;
	
	public DefaultLayout() {
		super("DefaultLayout");
		

		
	}

	@Override
	public void initGUI() {
			
		//First create the panels
	
		  //add north panel  
		  this.northPanel = new DiagramComponentPanel();  

		  northPanel.setHeight(113);
		  northPanel.setBorder(false);
		  HTML header = new HTML("<div class='inner-default-layout-header'></div>");
		  header.setStyleName("default-layout-header");
		  northPanel.add(header);
		  this.displayComponentsInPosition(northPanel, "menuPanel");

		  //add west Panel
		  this.westPanel = new DiagramComponentPanel();  
		  
		  westPanel.setTitle("Tools");
		  westPanel.setBorder(false);
		  westPanel.setTitleCollapse(true);
		  
		  westPanel.setAutoScroll(true);
		  westPanel.setCollapsible(true);  
		  westPanel.setWidth(200);  
		  
		  this.displayComponentsInPosition(westPanel, "westPanel");


		  //add south panel  
		  this.southPanel = new DiagramComponentPanel();  
		  southPanel.setHeight(200);  
		  southPanel.setCollapsible(true);  
		  southPanel.setTitle("");  
		  southPanel.setAutoScroll(true);
		  southPanel.setBorder(false);
		  
		  this.displayComponentsInPosition(southPanel,"southPanel");	
		
		
		  this.setBorder(false);  

		  this.setLayout(new FitLayout());  
		
		  Panel borderPanel = new Panel();  
		  borderPanel.setLayout(new BorderLayout());  


		  borderPanel.add(this.getNorthPanel(), new BorderLayoutData(RegionPosition.NORTH));  
	 


		  BorderLayoutData southData = new BorderLayoutData(RegionPosition.SOUTH);  
		  southData.setMinSize(100);  
		  southData.setMaxSize(200);  
		  southData.setMargins(new Margins(0, 0, 0, 0));  
		  southData.setSplit(true);  
		  borderPanel.add(this.getSouthPanel(), southData);  


		  //center panel
		  DiagramComponentPanel centerPanel = new DiagramComponentPanel();  
		  centerPanel.setLayout(new FitLayout());
		  centerPanel.setBodyStyle("background-color:#FFFFFF");  
		  centerPanel.setBorder(false);
		  
		  this.displayDrawingPanelTab(centerPanel);
		  

		  
		  AbsolutePanel panel = new AbsolutePanel();

		  centerPanel.add(panel);
		  //
		  
		  this.centerPanel = centerPanel;
		  
		  
		  BorderLayoutData westData = new BorderLayoutData(RegionPosition.WEST);  
		  westData.setSplit(true);  
		  westData.setMinSize(175);  
		  westData.setMaxSize(400);  
		  westData.setMargins(new Margins(0, 5, 0, 0));  

		  borderPanel.add(this.getWestPanel(), westData);  

		  borderPanel.add(centerPanel, new BorderLayoutData(RegionPosition.CENTER));  

		  this.add(borderPanel);  
		  
		  
		  // event logic
		  Window.addResizeHandler(this);
		  northPanel.addCollapseExpandHandler(this);
		  southPanel.addCollapseExpandHandler(this);
//		  centerPanel.addCollapseExpandHandler(this);
		  westPanel.addCollapseExpandHandler(this);
		  northPanel.addResizeHandler(this);
		  southPanel.addResizeHandler(this);
		  westPanel.addResizeHandler(this);
		  centerPanel.addResizeHandler(this);
		  
		  
		  Viewport viewport = new Viewport(this);  
	}
	
	
	public Panel getNorthPanel(){
		  return northPanel;
	}
	
	public Panel getWestPanel(){
		  return westPanel;
	}
	
	public Panel getSouthPanel(){
		  return southPanel;
	}
	
	public Panel getCenterPanel(){
		return centerPanel;
	}

	public void onResize(ResizeEvent arg0) {
		// resize the center panel to fit the page :)
		// let's calculate new dimensions ;)
		updateCentralBoundaries();
		
	}

	public void onCollapse(CollapseExpandEvent event) {
		updateCentralBoundaries();
	}

	public void onExpand(CollapseExpandEvent event) {
		updateCentralBoundaries();
	}
	
	/*
	 * Update internal widgets
	 * This is a huge hack, and might not be cross platform since some values are hard coded. 
	 * TODO : find a better way to achive this goal
	 */
	private void updateCentralBoundaries(){
		if (getDrawingPanelTab().getCurrentDrawingPanel() != null){
			// TODO : find a better way to resize these stuffs... 
			// it is really dirty this way...
			
			// another style related trick...
			int westSize = westPanel.getOffsetWidth() + 14;
			int width = 0;
			
			if (!westPanel.isCollapsed()){
				width = Window.getClientWidth() - westSize;
			}else{
				width = Window.getClientWidth() -34;
			}
			
			
			
			// trick !
			int southHeight = southPanel.getOffsetHeight();
			
			int height = 0;
			// this is a hack... very dirty !!
			// 7 is a compensation for the small split decoration
			// 36 is the size of a collapsed panel, decoration included
			// this is really realy dirty :'(...
			if (!southPanel.isCollapsed()){
				height = Window.getClientHeight() - getDrawingPanelTab().getCurrentDrawingPanel().getAbsoluteTop() - southHeight - 7; 
			}else{
				height = Window.getClientHeight() - getDrawingPanelTab().getCurrentDrawingPanel().getAbsoluteTop()-34;
			}
//			
			getDrawingPanelTab().updateDrawingZoneSize(width, height);
		}
	}

	@Override
	public void recompute() {
		updateCentralBoundaries();
	}
	
}
