/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.log;

import java.util.Date;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;

public abstract class AbstractLogEntry {

	private long occurenceTime;
	private Date occurenceDate;
	private String description;
	private DiagramElementInstance elementInstance;
	
	private Log log;

	
	public AbstractLogEntry(DiagramElementInstance elementInstance) {
		super();
		this.occurenceDate = new Date();
		this.occurenceTime = this.occurenceDate.getTime();
		this.elementInstance = elementInstance;
	}
	
	public AbstractLogEntry(DiagramElementInstance elementInstance, long time) {
		this.occurenceDate = new Date(time);
		this.occurenceTime = time;
		this.elementInstance = elementInstance;
	}
	
	protected abstract void undo();
	
	protected abstract void redo();
	
	public long getOccurenceTime() {
		return occurenceTime;
	}
	
	public abstract String getDescription();
	
	public Date getOccurenceDate() {
		return occurenceDate;
	}

	public void setOccurenceDate(Date occurenceDate) {
		this.occurenceDate = occurenceDate;
	}

	public void setOccurenceTime(long occurenceTime) {
		this.occurenceTime = occurenceTime;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public DiagramElementInstance getElementInstance() {
		return elementInstance;
	}

	public void setElementInstance(DiagramElementInstance elementInstance) {
		this.elementInstance = elementInstance;
	}
	
	public void setLog(Log log){
		this.log = log;
	}

	public Log getLog() {
		return log;
	}
	
	
	
	
}
