/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.log;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;

public class AddElementLogEntry extends AbstractLogEntry {
	
	private int x;
	private int y;
	
	public AddElementLogEntry(DiagramElementInstance elementInstance){
		super(elementInstance);
		this.x = -1;
		this.y = -1;
	}
	
	public AddElementLogEntry(DiagramElementInstance elementInstance, long time){
		super(elementInstance,time);
		this.x = -1;
		this.y = -1;
	}
	
	public AddElementLogEntry(DiagramElementInstance elementInstance, int x ,int y){
		super(elementInstance);
		this.x = x;
		this.y = y;
	}
	
	public AddElementLogEntry(DiagramElementInstance elementInstance, long time, int x ,int y){
		super(elementInstance,time);
		this.x = x;
		this.y = y;
	}

	@Override
	public String getDescription() {
		return "Element added at "+getOccurenceDate(); 
	}

	@Override
	protected void redo() {
		
//		DrawingPanel drawingPanel = getLog().getDrawingPanel();
//		DiagramElementInstance ei = getElementInstance();
//		
//		DiagramElementInstance copiedEi = ei.getClone();
//		if(x>0 && y>0){
//			drawingPanel.addElement(copiedEi, x,y);
//		}
		
		DrawingPanel drawingPanel = getLog().getDrawingPanel();
		getElementInstance().refreshViewInstance();
		
		if(x>0 && y>0){
			drawingPanel.addElement(getElementInstance(), x,y);
		}
	}

	@Override
	protected void undo() {
		getLog().getDrawingPanel().removeElement(getElementInstance());
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}
	
}
