/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.log;


import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;

public class RemoveElementLogEntry extends AbstractLogEntry {
	
	private int x;
	private int y;
	
	public RemoveElementLogEntry(DiagramElementInstance elementInstance){
		super(elementInstance);
		this.x = -1;
		this.y = -1;
	}
	
	public RemoveElementLogEntry(DiagramElementInstance elementInstance, long time){
		super(elementInstance,time);
		this.x = -1;
		this.y = -1;
	}
	
	public RemoveElementLogEntry(DiagramElementInstance elementInstance, int x ,int y){
		super(elementInstance);
		this.x = x;
		this.y = y;
	}
	
	public RemoveElementLogEntry(DiagramElementInstance elementInstance, long time, int x ,int y){
		super(elementInstance,time);
		this.x = x;
		this.y = y;
	}

	@Override
	public String getDescription() {
		return "Element removed at "+getOccurenceDate();
	}

	@Override
	protected void redo() {
		getLog().getDrawingPanel().removeElement(getElementInstance());
	}

	@Override
	protected void undo() {
//		DrawingPanel drawingPanel = getLog().getDrawingPanel();
//		DiagramElementInstance ei = getElementInstance();
//
//		if(x>0 && y>0){
//			drawingPanel.addElement(ei.getElementType(),x,y);
//		}
		
		DrawingPanel drawingPanel = getLog().getDrawingPanel();
		getElementInstance().refreshViewInstance();

		if(x>0 && y>0){
			drawingPanel.addElement(getElementInstance(), x, y);
		}
	}
	
	public void setX(int x) {
		this.x = new Integer(x);
	}
	
	public void setY(int y) {
		this.y = new Integer(y);
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}
	
	
}
