/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.PropertyChangedHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;

@SuppressWarnings("unchecked")
public class DiagramModel {

	private List<DiagramModelGroup> groups;



	private ArrayList<PropertyChangedHandler> propertyChangedHandlers = new ArrayList<PropertyChangedHandler>();
	
	
	public DiagramModel() {

		this.groups = new ArrayList<DiagramModelGroup>();
	}

	public void addModelGroup(DiagramModelGroup group) {
		this.groups.add(group);
	}

	public DiagramModelGroup getGroupByName(String name) {

		for (DiagramModelGroup group : this.groups) {

			if (group.getName().equals(name)) {
				return group;
			}
		}
		return null;
	}

	
	public ArrayList<PropertyChangedHandler> getPropertyChangedHandlers() {
		return propertyChangedHandlers;
	}
	
	public DiagramProperty<?> getPropertyByName(String name) {

		for (DiagramModelGroup group : this.groups) {

			if (group.getPropertyByName(name)!=null) return group.getPropertyByName(name); 

		}

		return null;

	}
	
	
	public ArrayList<DiagramProperty<?>> getAllProperties(){
		
		ArrayList<DiagramProperty<?>> result = new ArrayList<DiagramProperty<?>>();
		
		for(DiagramModelGroup group:this.groups){
			
			for(DiagramProperty<?> p:group.getProperties()){
				result.add(p);
			}
			
		}
		
		return result;
	}

	public void addPropertyChangedHandler(PropertyChangedHandler handler){
		this.propertyChangedHandlers.add(handler);
	}

	public List<DiagramModelGroup> getModelGroups() {
		return groups;
	}
	
	
	public <T> List<DiagramProperty<T>> getPropertiesForType(Class<T> type){
		ArrayList<DiagramProperty<T>> returnList = new ArrayList<DiagramProperty<T>>();
		for (DiagramModelGroup group : groups) {
			for (DiagramProperty<?> property : group.getProperties()) {
				if (property.getValue().getClass().equals(type)){
					// add it to the list :)
					returnList.add((DiagramProperty<T>) property);
				}
			}
		}
		return returnList;
		
	}
	

	
}
