/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.gwtext.client.widgets.form.Checkbox;
import com.gwtext.client.widgets.form.event.CheckboxListenerAdapter;

public class BooleanEditor extends Checkbox implements
		ValueChangeHandler<Boolean> {

	
	private DiagramProperty<Boolean> property;
	private HandlerRegistration propertyRegistration;
	
	public BooleanEditor(DiagramProperty<Boolean> p) {
		property = p ;
		setValue(p.getValue());
		propertyRegistration = p.addValueChangeHandler(this);
		addListener(new CheckboxListenerAdapter(){
			@Override
			public void onCheck(Checkbox field, boolean checked) {
				super.onCheck(field, checked);
				property.setValue(checked);
			}
		});
		
	}
	
	public void onValueChange(ValueChangeEvent<Boolean> evt) {
		if (evt.getSource().equals(property)){
			setValue(evt.getValue());
		}

	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		// cleaning
		propertyRegistration.removeHandler();
	}
	

}
