/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors;

import java.util.Date;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.gwtext.client.widgets.DatePicker;
import com.gwtext.client.widgets.event.DatePickerListenerAdapter;
import com.gwtext.client.widgets.form.DateField;

public class DateEditor extends DateField implements ValueChangeHandler<Date> {
	
	private DiagramProperty<Date> property ;
	private HandlerRegistration propertyRegistration;
	
	public DateEditor(DiagramProperty<Date> p) {
		 property = p ;
		 setValue(property.getValue());
		 propertyRegistration = p.addValueChangeHandler(this);
		 addListener(new DatePickerListenerAdapter(){
			 @Override
			public void onSelect(DatePicker dataPicker, Date date) {
				// TODO Auto-generated method stub
				super.onSelect(dataPicker, date);
				property.setValue(date);
			}
		 });
	}

	public void onValueChange(ValueChangeEvent<Date> arg0) {
		if (arg0.getSource().equals(property)){
			setValue(arg0.getValue());
		}

	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		// cleaning
		propertyRegistration.removeHandler();
	}
	

}
