/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.EnumProperty;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.SimpleStore;
import com.gwtext.client.data.Store;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;

public class EnumEditor<E extends Enum<?>> extends ComboBox implements ValueChangeHandler<E>{
	
	private DiagramProperty<E> property ;
	private HandlerRegistration propertyRegistration;
	private String values[] ;
	
	public EnumEditor(DiagramProperty<E> p) {
		property = p ;
		
		values = new String[p.getValue().getClass().getEnumConstants().length];
		int initialSelection = 0 ;
		for (int i = 0 ; i < p.getValue().getClass().getEnumConstants().length ; i ++){
			if (p.getValue() instanceof EnumProperty){
				EnumProperty ep = (EnumProperty) p.getValue().getClass().getEnumConstants()[i];
				values[i] = ep.getDisplayString();
			}else{
				values[i] = p.getValue().getClass().getEnumConstants()[i].toString();
			}
			
			// initial selection
			if (p.getValue().getClass().getEnumConstants()[i].equals(property.getValue())){
				initialSelection = i ;
			}
		}
		
		Store store = new SimpleStore("value", values);
		store.load();
		
		setHiddenName("value");  
		setStore(store);  
		setDisplayField("value");   
		setReadOnly(true);
		setMode(ComboBox.LOCAL);  
		setTriggerAction(ComboBox.ALL);    
		setSelectOnFocus(true);  
		setHideTrigger(false);
		
		setValue(values[initialSelection]);
		
		addListener(new ComboBoxListenerAdapter(){
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				// TODO Auto-generated method stub
				super.onSelect(comboBox, record, index);
				property.setValue(mapFromIndexToEnum(index));
			}
		});
		
		
	}

	public void onValueChange(ValueChangeEvent<E> arg0) {
		if(arg0.getSource().equals(property)){
			setValue(mapFromEnumToString(arg0.getValue()));
		}
		
	}
	
	private String mapFromEnumToString(E value){
		for (int i = 0 ; i < property.getValue().getClass().getEnumConstants().length ; i++){
			if (property.getValue().getClass().getEnumConstants()[i].equals(value)){
				return values[i];
			}
		}
		return null;
	}
	
	@SuppressWarnings("unchecked")
	private E mapFromIndexToEnum(int index){
		return (E) property.getValue().getClass().getEnumConstants()[index];
		
	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		// cleaning
		propertyRegistration.removeHandler();
	}
	
	

}
