/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors;

import gwtupload.client.IUploader;
import gwtupload.client.SingleUploader;
import gwtupload.client.IUploader.OnFinishUploaderHandler;
import gwtupload.client.IUploader.OnStartUploaderHandler;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer.DesignerProxyHelper;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.StdAsyncCallback;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.WebDesignerService;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.WebDesignerServiceAsync;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.window.DesignerWindow;
import com.google.gwt.core.client.GWT;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;

import com.google.gwt.user.client.ui.Label;
import com.gwtext.client.widgets.Component;

import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.WindowListenerAdapter;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.TextFieldListenerAdapter;

/**
 * 
 * @author nfleury
 *
 */
public class FileEditor extends TextField implements ValueChangeHandler<File> {

	private DiagramProperty<File> property;
	private HandlerRegistration propertyRegistration; 
	
	public static String UPLOAD_PATH;
	
	private WebDesignerServiceAsync designerService = (WebDesignerServiceAsync) GWT.create(WebDesignerService.class);
	private Label lbl_fileName;
	private Label lbl_fileURL;
	
	public FileEditor(final DiagramProperty<File> p) {

		property = p;
		propertyRegistration = p.addValueChangeHandler(this);
		setValue(p.getValue().getName());
		
		lbl_fileName = new Label();
		lbl_fileURL = new Label();
		
		addListener(new TextFieldListenerAdapter(){
			
			


			@Override
			public void onRender(Component component) {
				//MessageBox.alert(component.getParent().getElement().getId());
				super.onRender(component);
			}
			
			
			@Override
			public void onFocus(Field field) {
					
	
				  final SingleUploader singleUploader = new SingleUploader();
				  singleUploader.setAutoSubmit(true);

				  final DesignerWindow win = new DesignerWindow(DesignerProxyHelper.designer);
				  win.setTitle("Select a file to upload");
				  win.setHeight(100);
				  win.setWidth(550);
				  refreshLabels();
				  win.add(lbl_fileName);
				  win.add(lbl_fileURL);
				  win.add(singleUploader);
				  //singleUploader.setAutoSubmit(true);
			win.show();
			
				  
				  singleUploader.addOnStartUploadHandler(new OnStartUploaderHandler(){
			
					public void onStart(IUploader uploader) {
						
						win.hide();
						
					}
					  
				  });
				  
				  singleUploader.addOnFinishUploadHandler(new OnFinishUploaderHandler(){
			
						public void onFinish(final IUploader uploader) {
								
								designerService.uploadFile(uploader.fileUrl(), UPLOAD_PATH, new StdAsyncCallback<String>(){
									@Override
									public void onSuccess(String uploadPath) {
										
										File file = new File(uploader.getFileName(),uploadPath,uploader.getBasename());
										property.setValue(file);
										refreshLabels();
										DesignerProxyHelper.designer.getController().unmask();
										
									}
								});
							  
							  singleUploader.getStatusWidget().setVisible(false);
							  
							  
					        
							
						}
						  
						  
					  });
				
				win.addListener(new WindowListenerAdapter(){
					@Override
					public void onClose(Panel panel) {
					
							win.destroy();
							win.removeAll();
							DesignerProxyHelper.designer.getController().unmask();
						
					}
				});
				
				
			}
			
		});
		
		
	}


	private void refreshLabels(){
		  this.lbl_fileName.setText("File name:"+property.getValue().getName());
		  this.lbl_fileURL.setText("File URL:"+property.getValue().getURL());
	}

	public void onValueChange(ValueChangeEvent<File> arg0) {
		if (arg0.getSource().equals(property)){
		
			setValue(arg0.getValue().getName());
		}
		
	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		// cleaning
		propertyRegistration.removeHandler();
	}

}
