/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.gwtext.client.widgets.form.Field;

/**
 * Factory to create a field in property editor.<br>
 * The field is created given the type of the property value.<br> 
 *  
 * 
 * <b>Important:</b> Primitive / Generic types are already registered, but every new type has <br>
 * to be registered in order to be properly rendered in the property grid.<br>
 * <br>
 * TODO: improve / find a better way  --- <b>NOT A PRIORITY</b> 
 * 
 * @author enhan, nfleury
 *
 */
public class PropertyEditorFactory {
	
	
	private static HashMap<Class<?>, Field > registeredTypes = new HashMap<Class<?>, Field>();
	
	private static ArrayList<PropertyEditorRegistratorHandler> rhandlers = new ArrayList<PropertyEditorRegistratorHandler>();


	/**
	 * This method performs cast check by instanceof statements
	 * @param p
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static Field getEditorForProperty(DiagramProperty<?> p){

		if (p.getValue() instanceof String){
		
			StringEditor se = new StringEditor((DiagramProperty<String>) p);
			registeredTypes.put(String.class, se);
		
		}else if(p.getValue() instanceof Boolean){
			
			BooleanEditor be = new BooleanEditor((DiagramProperty<Boolean>) p);
			registeredTypes.put(Boolean.class,be);
			
		}else if (p.getValue() instanceof Date){
			
			DateEditor de = new DateEditor( (DiagramProperty<Date>) p);
			registeredTypes.put(Date.class, de);
			
		}else if (p.getValue() instanceof Enum){
			
			EnumEditor<Enum<?>> ee = new EnumEditor<Enum<?>>((DiagramProperty<Enum<?>>) p);
			registeredTypes.put(p.getValue().getClass(), ee);
		
		}else if (p.getValue() instanceof File){
			
			FileEditor fe = new FileEditor((DiagramProperty<File>) p);
			registeredTypes.put(File.class, fe);
			
		}else if (p.getValue() instanceof DiagramSetType){
			
			 Class clazz =  ((DiagramSetType<?>)p.getValue()).getGeneriClass();
			
				for(PropertyEditorRegistratorHandler h: SetPropertyEditorFactory.getRHandlers()){
					h.registerEditor(p);
				} 
			 
			Field field = SetPropertyEditorFactory.getFieldByClass(clazz);
			
			return field;
			
		}

		
		for(PropertyEditorRegistratorHandler h:rhandlers){
			h.registerEditor(p);
		}
		
		
		Field f = registeredTypes.get(p.getValue().getClass());
		
		
		return f;
		
	}
	
	public static Field getFieldByClass(Class<?> clazz){
		return registeredTypes.get(clazz);
	}
	
	
	public static void registerType(Class<?> clazz,Field field){
		registeredTypes.put(clazz, field);
	}
	
	/**
	 * Register the handler to register a property editor ... weird huh ? ... <br>
	 * 
	 * @param handler
	 */
	public static void registerPropertyEditorRegistratorHandler(PropertyEditorRegistratorHandler handler){
		rhandlers.add(handler);
	}

	public static ArrayList<PropertyEditorRegistratorHandler> getRHandlers(){
		return rhandlers;
	}
}
