/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.TextFieldListenerAdapter;

public class StringEditor extends TextField implements
		ValueChangeHandler<String> {

	private DiagramProperty<String> property;
	private HandlerRegistration propertyRegistration; // need to be used to cleanly free memory and avoid leaks
	
	
	public StringEditor(DiagramProperty<String> p) {
		property = p ;
		propertyRegistration = p.addValueChangeHandler(this);
		setValue(p.getValue());
		
		addListener(new TextFieldListenerAdapter(){

			@Override
			public void onChange(Field field, Object newVal, Object oldVal) {
				super.onChange(field, newVal, oldVal);
				property.setValue(getValueAsString());
			}
			
		});
		
	}
	
	public void onValueChange(ValueChangeEvent<String> arg0) {
		if (arg0.getSource().equals(property)){
			setValue(arg0.getValue());
		}

	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		// cleaning
		propertyRegistration.removeHandler();
	}
	

}
