/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.renderer;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DrawingPanelComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntax;

public abstract class DiagramRenderer extends Renderer {

	private DiagramSyntax diagramSyntax;

	private DrawingPanelComponent drawingPanelComponent;
	
	public DiagramRenderer(String name,DiagramSyntax syntax) {
		super(name);
		
		this.diagramSyntax = syntax;
	}

	
	public void setDrawingPanelComponent(DrawingPanelComponent drawingPanelComponent) {
		this.drawingPanelComponent = drawingPanelComponent;
	}
	
	public DrawingPanelComponent getDrawingPanelComponent() {
		return drawingPanelComponent;
	}
	
	public DiagramSyntax getDiagramSyntax() {
		return diagramSyntax;
	}

}
