/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc;

import com.ebmwebsourcing.webdesigner.business.domain.exception.WebDesignerServiceException;
import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("designerservice")
public interface WebDesignerService extends RemoteService {

	public SyntaxModel loadModelFromFile(String syntaxName,String version,String fileUrl,String fileFormat) throws WebDesignerServiceException;
	
	public String createFileFromModel(SyntaxModel model,String syntaxName,String version,String fileFormat) throws WebDesignerServiceException; 
	
	public String uploadFile(String fileUrl,String uploadPath) throws WebDesignerServiceException;
	
}
