/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;


public class DesignValidationException extends Exception {

	/**
	 * Mapping element instance violating the syntax -- message describing the violation
	 */
	private Map<DiagramElementInstance,String> errors;
	
	/**
	 * Only for serialization : do not use it
	 */
	public DesignValidationException(){
		super();
		errors = new HashMap<DiagramElementInstance, String>();
	}
	
	public DesignValidationException(DiagramElementInstance ei, String message){
		addError(ei, message);
	}
	
	
	public DesignValidationException(Collection<DesignValidationException> exceptions){
		for(DesignValidationException dve : exceptions){
			for(DiagramElementInstance ei : dve.getErrors().keySet()){
				addError(ei, dve.getErrors().get(ei));
			}
		}
	}
	
	private void addError(DiagramElementInstance ei, String message){
		if(errors==null){
			errors = new HashMap<DiagramElementInstance, String>();
		}
		errors.put(ei, message);
	}


	public Map<DiagramElementInstance, String> getErrors() {
		return errors;
	}


	public void setErrors(Map<DiagramElementInstance, String> errors) {
		this.errors = errors;
	}
	
	@Override
	public String getMessage(){
		StringBuffer sb = new StringBuffer();
		
		if(errors!=null){
			for(String msg : errors.values()){
				sb.append(msg);
				sb.append("<br>");
			}
		}
		
		return sb.toString();
	}
}
