/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.widget;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors.File;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListenerAdapter;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.event.TextFieldListenerAdapter;

public abstract class AbstractDiagramWindowPropertyWidget extends TextField {
	
	//protected DiagramProperty<?> property;
	protected Field field;
	
	
	public AbstractDiagramWindowPropertyWidget(int width,int height, DiagramProperty<?> p) {
		
		//this.property = property;
		

		final Window win = new Window();
		win.setWidth(width);
		win.setHeight(height);
		
		win.addListener(new WindowListenerAdapter(){
			
			@Override
			public void onClose(Panel panel) {
				
				AbstractDiagramWindowPropertyWidget.this.field.setValue(getDisplayTextOnComplete()) ;
			MessageBox.alert("field value"+field.getValueAsString() + "is rendered:" + field.isRendered());
			field.focus();
			
			}
			
		});
		
		
		this.addListener(new TextFieldListenerAdapter(){
			
			

			
			@Override
			public void onFocus(Field field) {
				super.onFocus(field);
				
				win.show();
				win.add(AbstractDiagramWindowPropertyWidget.this.getContentPanel());
				
				
				AbstractDiagramWindowPropertyWidget.this.field = field;
				
			}
			
		});
		
		
		

		

		
	
	}
	
	public abstract String getDisplayTextOnInitialize();
	
	public abstract String getDisplayTextOnComplete();
	
	public abstract Panel getContentPanel();
	
	
	
	
}
