/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.window;

import com.ebmwebsourcing.gwt.jquery.client.core.J4GUI;
import com.ebmwebsourcing.gwt.jquery.client.core.JqueryUI;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer.Designer;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.gwtext.client.core.Ext;
import com.gwtext.client.core.ExtElement;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListenerAdapter;

/**
 * 
 * @author nfleury
 *
 */
public class DesignerWindow extends Window {
	
	private Designer designer;
	private J4GUI jqueryObject;
	
	public DesignerWindow(Designer designer) {
		super();
		
		this.designer = designer;
		
		//unmask first to avoid multiple masks
		designer.getController().unmask();
		designer.getController().mask();
		
		this.addStyleName("designerWindow");

		
		
		
		this.addListener(new WindowListenerAdapter(){
			
			@Override
			public void onShow(Component component) {
				

				
				final JqueryUI jui 		= new JqueryUI();
				
				jqueryObject 	= jui.$(".designerWindow");
				
				jqueryObject.css("z-index", "500000");
				
				
				DeferredCommand.addCommand(new Command(){
					public void execute() {

						//as combo lists are on a lower z-index, bring them to front
						jui.$(".x-combo-list").css("z-index", "60000000");
						
					}
				});

				
			}
			
			public void onClose(Panel panel) {
				
				getDesigner().getController().unmask();
				
			}
		});
	
	}
	
	

	public Designer getDesigner() {
		return designer;
	}
	
	
}
