/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.server.syntaxloader;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;

/**
 * 
 * @author nfleury
 *
 */
public abstract class AbstractSyntaxModelToFileWriter {
	
	
	private SyntaxModel model;
	private File file;
	private String appRootPath;
	private String relativeDownloadURL;
	
	public void setFile(File file){
		this.file = file;
	}
	
	public abstract File getFile() throws Exception;
	
	public SyntaxModel getModel() {
		return model;
	}
	
	public void setRelativeDownloadURL(String relativeUploadURL) {
		this.relativeDownloadURL = relativeUploadURL;
	}
	
	public String getRelativeDownloadURL() {
		return relativeDownloadURL;
	}
	
	public void setAppRootPath(String uploadPath) {
		this.appRootPath = uploadPath;
	}
	
	public String getAppRootPath() {
		return appRootPath;
	}
	
	public void setModel(SyntaxModel model) {
		this.model = model;
	}
	

	
}
