/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.server.syntaxloader;



import java.io.File;

import org.apache.commons.fileupload.FileItem;

import com.ebmwebsourcing.webdesigner.business.domain.exception.SyntaxLoaderException;
import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;


/**
 * 
 * @author nfleury
 *
 */
public class DiagramSyntaxLoader {
	
	private FileItem fileItem;
	
	private SyntaxModel model;
	
	private String uploadPath;

	private File file;
	
	public DiagramSyntaxLoader(FileItem file) {
		this.fileItem = file;
	}
	
	public DiagramSyntaxLoader(SyntaxModel model) {
		this.model = model;
	}
	
	public DiagramSyntaxLoader(File file) {
		this.file = file;
	}

	public void setUploadPath(String uploadPath) {
		this.uploadPath = uploadPath;
	}
	
	public String getUploadPath() {
		return uploadPath;
	}
	
	
	public SyntaxModel loadSyntaxModelFromFile(String syntaxName,String version,String fileUrl,String fileFormat) throws SyntaxLoaderException{
		
		try {
		
			Class syntaxLoader = Class.forName("com.ebmwebsourcing.webdesigner.server.syntaxloader."+fileFormat.toUpperCase()+"to"+syntaxName.toUpperCase()+version+"loader");
			
			AbstractSyntaxFileToModelLoader ab = (AbstractSyntaxFileToModelLoader) syntaxLoader.newInstance();
			
			ab.setFileItem(fileItem);
			ab.setFile(file);
			ab.setUploadPath(getUploadPath());
			
			return ab.getModel();
			
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			throw new SyntaxLoaderException("Class not found: "+e.getMessage());
		
		} catch (InstantiationException e) {
			e.printStackTrace();
			throw new SyntaxLoaderException("Syntax loader exception"+e.getMessage());
		
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new SyntaxLoaderException("IllegalAcces exception"+e.getMessage());

		} catch(Exception e){
			e.printStackTrace();
			throw new SyntaxLoaderException("Couldnt load model from file");
		}
		
		
		
		
	}

	public String loadFileURLFromModel(String syntaxName, String version,String fileFormat) throws SyntaxLoaderException {

		try {
			
			Class syntaxLoader = Class.forName("com.ebmwebsourcing.webdesigner.server.syntaxloader."+syntaxName.toUpperCase()+version+"to"+fileFormat.toUpperCase()+"writer");
			
			AbstractSyntaxModelToFileWriter ab = (AbstractSyntaxModelToFileWriter) syntaxLoader.newInstance();
			
			ab.setModel(model);
			ab.setAppRootPath(getUploadPath());
			
			ab.getFile();
			
			return ab.getRelativeDownloadURL();
			
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			throw new SyntaxLoaderException("Class not found: "+e.getMessage());
		
		} catch (InstantiationException e) {
			e.printStackTrace();
			throw new SyntaxLoaderException("Syntax loader exception:"+e.getMessage());
		
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new SyntaxLoaderException("IllegalAcces exception:"+e.getMessage());

		} catch (Exception e) {
			e.printStackTrace();
			throw new SyntaxLoaderException("Could not create File from model:"+e.getMessage());
		}
		

		
	}


	
}
