/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer;

import java.util.HashMap;

import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;

/**
 * 
 * @author nfleury
 *
 */
public class DesignerModel {
	
	public DesignerController controller;
	
	public DesignerModel(DesignerController controller) {
		this.controller = controller;
	}
	
	
	public SyntaxModel getSyntaxModelById(String id){
		return this.getAllLoadedSyntaxModel().get(id);
	}
	
	
	public HashMap<String, SyntaxModel> getAllLoadedSyntaxModel(){
	
		HashMap<String, SyntaxModel> result = new HashMap<String, SyntaxModel>();
		
		for(DrawingPanel dp:controller.getDesigner().getRegistry().getLayout().getDrawingPanelTab().getDrawingPanels().values()){
			
			result.put(dp.getSyntaxModel().getId(), dp.getSyntaxModel());
			
		}
	
		return result;
	}


	public DrawingPanel getDrawingPanelBySyntaxModelId(String id) {
		return controller.getDesigner().getRegistry().getLayout().getDrawingPanelTab().getDrawingPanels().get(id);
		
	}
	 
	
}
