/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax;

import java.util.ArrayList;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModelGroup;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.google.gwt.user.client.ui.Widget;

public class DiagramElementInstance {
	
	private Widget viewInstance;
	private DrawingPanel drawingPanel;
	private DiagramElementType elementType;
	private DiagramModel elementModel;
	private ArrayList<DiagramElementInstance> children = new ArrayList<DiagramElementInstance>();
	
	public DiagramElementInstance(Widget viewInstance,DrawingPanel drawingPanel,DiagramElementType elementType) {
		
		this.viewInstance = viewInstance;
		this.drawingPanel = drawingPanel;
		this.elementType  = elementType;
		
		//Duplicate the type model for current element
		//in order to preserve data persistence
		this.elementModel = this.copyModel(elementType.getModel());

//		this.elementModel.addModelGroup(newGroup);
	}
	
	public DiagramElementInstance(Widget viewInstance,DrawingPanel drawingPanel,DiagramElementType elementType,DiagramModel model) {
		
		this(viewInstance,drawingPanel,elementType);
		this.elementModel = model;
	}
	
	/**
	* Cloning an element consists of creating a new element <br>
	* based on the type of the instance to clone and to copy <br>
	* its model to the new cloned element
	*/  
	public DiagramElementInstance getClone(){
		
		//create a new view instance
		Widget newView 					= this.getDrawingPanel().getSyntax().getSyntaxFactory().createDiagramElementView(this.getElementType());
		
		//copy the model
		DiagramModel model				= this.copyModel(elementModel);
		
		DiagramElementInstance clone 	= new DiagramElementInstance(newView,this.getDrawingPanel(),this.getElementType(),model);
		
		return clone;
	}
	
	public void refreshViewInstance(){
		Widget newView = this.getDrawingPanel().getSyntax().getSyntaxFactory().createDiagramElementView(this.getElementType());
		this.viewInstance = newView;
	}
	

	public void addChild(DiagramElementInstance instance){
		this.children.add(instance);
	}
	
	public ArrayList<DiagramElementInstance> getChildren() {
		return children;
	}
	
	public Widget getViewInstance() {
		return viewInstance;
	}

	public DrawingPanel getDrawingPanel() {
		return drawingPanel;
	}

	public DiagramElementType getElementType() {
		return elementType;
	}
	
	public DiagramModel getElementModel() {
		return elementModel;
	}
	
	private DiagramModel copyModel(DiagramModel modelToCopy){
		
		DiagramModel model = new DiagramModel();
		
		model.getPropertyChangedHandlers().addAll(modelToCopy.getPropertyChangedHandlers());
		
		for(DiagramModelGroup group:modelToCopy.getModelGroups()){
			
			DiagramModelGroup newGroup = new DiagramModelGroup(group.getName());
			
			//Add each property to the group
				for(DiagramProperty<?> property:group.getProperties()){
					// property copy from model 
					DiagramProperty<?> newProperty = property.createNewInstanceOfProperty(this);
					newProperty.copyPropertyValue(property);
					newGroup.addProperty(newProperty);

				}
				model.addModelGroup(newGroup);
		}
		
		return model;
		
	}
	
	
}
