/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax;

import java.util.ArrayList;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DiagramElementTypeInstantiationHandler;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModel;
import com.google.gwt.user.client.ui.Widget;


public abstract class DiagramElementType {
	
	private String name;

	
	private Widget view;
	private DiagramModel model;
	private DiagramElementGroup diagramElementGroup;
	private ArrayList<DiagramElementTypeInstantiationHandler> instantiationHandlers = new ArrayList<DiagramElementTypeInstantiationHandler>();
	
	
	public DiagramElementType(String name) {
		this.name = name;
	}
	

	
	public abstract String getIco();
	
	public String getName() {
		return name;
	}
	

	public Widget generateViewInstance() {

			return this.getDiagramElementGroup()
			.getDiagramSyntaxGroup()
			.getDiagramSyntax()
			.getSyntaxFactory()
			.createDiagramElementView(this);
	
	}
	
	public void setModel(DiagramModel model) {
		this.model = model;
	}
	
	public DiagramModel getModel() {
		return model;
	}

	public void setDiagramElementGroup(DiagramElementGroup diagramElementGroup) {
		this.diagramElementGroup = diagramElementGroup;
	}
	
	public DiagramElementGroup getDiagramElementGroup() {
		return diagramElementGroup;
	}
	
	
	public void addInstantiationHandler(DiagramElementTypeInstantiationHandler handler){
		this.instantiationHandlers.add(handler);
	}
	
	public ArrayList<DiagramElementTypeInstantiationHandler> getInstantiationHandlers(){
		return this.instantiationHandlers;
	}

	
	
	@Override
	public boolean equals(Object obj) {
		
		DiagramElementType el = (DiagramElementType) obj;
	
		return el.getName().equals(this.getName());
	}
	
}
