/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax;

import java.util.ArrayList;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;






public class DiagramSyntax {
	
	private String name;
	
	private ArrayList<DiagramSyntaxGroup> syntaxGroups = new ArrayList<DiagramSyntaxGroup>();

	private SyntaxFactory syntaxFactory;
	
	public DiagramSyntax(String name,SyntaxFactory syntaxFactory) {
		
		this.name 			= name;
		this.syntaxFactory 	= syntaxFactory;
	
	}
	
	public void addSyntaxGroup(DiagramSyntaxGroup group){
		this.syntaxGroups.add(group);
		group.setDiagramSyntax(this);
	}
	
	public SyntaxFactory getSyntaxFactory() {
		return syntaxFactory;
	}
	
	
	public ArrayList<DiagramSyntaxGroup> getSyntaxGroups() {
		return syntaxGroups;
	}
	
	
	public String getName() {
		return name;
	}
	
	
	public DiagramElementType getTypeByName(String name){
		
		for(DiagramSyntaxGroup group:syntaxGroups){
			
			for(DiagramElementGroup elGroup:group.getElementGroups()){
				if (elGroup.getElementTypeByName(name) != null) return elGroup.getElementTypeByName(name);
			}
			
		}
		
		
		return null;
	}
	
	
	@Override
	public boolean equals(Object obj) {
		
		DiagramSyntax syntax = (DiagramSyntax) obj;
		
		return (syntax.getName().equals(this.getName()));

	}
	
	@Override
	public int hashCode() {
		return this.getName().hashCode();
	}
	
}
