/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.event;

import com.google.gwt.event.shared.GwtEvent;

public class CollapseExpandEvent extends GwtEvent<CollapseExpandHandler> {
	
	private static Type<CollapseExpandHandler> TYPE;
	
	public enum Operation{
		EXPAND,
		COLLAPSE
	}
	
	private Operation current;
	
	protected CollapseExpandEvent(HasCollapseExpandHandlers source, Operation op){
		current = op;
	}
	
	public static Type<CollapseExpandHandler> getType(){
		if (TYPE == null){
			TYPE = new Type<CollapseExpandHandler>();
		}
		return TYPE;
	}

	
	public static void fire(HasCollapseExpandHandlers source, Operation op){
		if (TYPE != null){
			CollapseExpandEvent ev = new CollapseExpandEvent(source, op);
			source.fireEvent(ev);
		}
	}
	
	@Override
	protected void dispatch(CollapseExpandHandler handler) {
		switch (current){
		case COLLAPSE:
			handler.onCollapse(this);
			break;
		case EXPAND:
			handler.onExpand(this);
			break;
		}
	}

	@Override
	public Type<CollapseExpandHandler> getAssociatedType() {
		return TYPE;
	}

}
