/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.event;

import java.util.ArrayList;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;

public interface DrawingPanelListener {
	
	public void onLoad();
	
	public void onDiagramElementAdded(DiagramElementInstance elementInstance,int x,int y);

	public void onDiagramElementAdded(DiagramElementInstance elementInstance);
	
	public void onDiagramElementsSelected(ArrayList<DiagramElementInstance> selectedElementInstances);
	
	public void onDiagramElementsUnSelected(ArrayList<DiagramElementInstance> unselectedElementInstances);
	
	public void onDiagramElementRemoved(DiagramElementInstance elementInstance);

	public void onDiagramElementUpdated(DiagramElementInstance elementInstance,Object dataBeforeUpdate,Object dataAfterUpdate);
	
	public void onClick();


	
}
