/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.helper;

import gwtupload.client.IUploader;
import gwtupload.client.SingleUploader;

import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.StdAsyncCallback;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.WebDesignerService;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.WebDesignerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.gwtext.client.widgets.MessageBox;


public class FileToModelUploader extends SingleUploader {
	
	private String syntaxName;
	private String version;
	private String fileToUploadFormat;
	
	private FileToModelUploaderListener listener;
	
	private WebDesignerServiceAsync designerService = (WebDesignerServiceAsync) GWT.create(WebDesignerService.class);	
	
	public FileToModelUploader(String syntaxName,String version,String fileToUploadFormat,FileToModelUploaderListener listener) {
	
		this.syntaxName 		= syntaxName;
		this.version			= version;
		this.fileToUploadFormat	= fileToUploadFormat;
		
		this.listener			= listener;
		
		this.addOnFinishUploadHandler(new OnFinishUploaderHandler(){
			public void onFinish(IUploader uploader) {
				
				loadModel(uploader.fileUrl());
				
			}
		});
		
		
		  final com.gwtext.client.widgets.Window win = new com.gwtext.client.widgets.Window();
		  
		  win.setHeight(75);
		  win.setWidth(550);
		  
		  win.add(this);
		  
		  win.show();
		  
		 this.addOnStartUploadHandler(new OnStartUploaderHandler(){
			 public void onStart(IUploader uploader) {
				 
				 win.hide();
				
			}
		 }) ;
		  
	}
	
	
	private void loadModel(String fileURL){
		
		this.designerService.loadModelFromFile(syntaxName, version, fileURL, fileToUploadFormat, new StdAsyncCallback<SyntaxModel>(){

			public void onFailure(Throwable arg0) {
				
				//MessageBox.alert(arg0.getMessage());
				
				listener.onFailure(arg0);
				
			super.onFailure(arg0);
			}

			public void onSuccess(SyntaxModel model) {
				
				listener.onSucces(model);
				
			}
			
			
			
			
		});
		
	}
	
}
