/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout;


import java.util.HashMap;



import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.DiagramComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.designer.Designer;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DDPaletteElement;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementType;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DiagramElementTypeInstantiationHandler;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.AllView;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.view.DiagramView;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.dd.DragData;
import com.gwtext.client.dd.DragSource;
import com.gwtext.client.dd.DropTarget;
import com.gwtext.client.dd.DropTargetConfig;
import com.gwtext.client.widgets.BoxComponent;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.event.PanelListenerAdapter;
import com.gwtext.client.widgets.tree.TreeDragData;
import com.gwtext.client.widgets.tree.TreeNode;

/**
 * 
 * @author nfleury
 *
 * TODO: Find a better way to handle dragndrop from palette to drawing zone !!
 *
 */
public abstract class DiagramLayout extends Panel{
	
	private String name;
	
	private Designer designer;
	
	private DrawingPanelTab drawingPanelTab;
	
	private DiagramView currentView;
	
	private HashMap<DiagramComponent,Widget> displayedComponents = new HashMap<DiagramComponent,Widget>() ;
	private HashMap<Widget, Panel> diaplayedComponentsParents	 = new HashMap<Widget, Panel>();
	
	public DiagramLayout(String name) {
		
		this.name = name;
		
		this.drawingPanelTab = new DrawingPanelTab(this);
		
        DropTargetConfig cfg 	= new DropTargetConfig();
        cfg.setdDdGroup("diagramPanel");
		


        @SuppressWarnings("unused")
		DropTarget tg = new DropTarget(getDrawingPanelTab(), cfg){
        	

            public String notifyOver(DragSource src, EventObject e, DragData data) {
            	
                TreeDragData treeDragData = (TreeDragData) data;
                final TreeNode treeNode = treeDragData.getTreeNode();
                
                DiagramElementType elementType = (DiagramElementType) treeNode.getAttributeAsObject("DiagramElementType");

                PaletteDDHelper.currentDraggedElementType = (DDPaletteElement) elementType;
                
                String icoCls = "x-tree-drop-ok-append";
                
                if (!PaletteDDHelper.currentDraggedElementType.isDroppableOnDrawingPanel()){
                	
                	icoCls = "x-dd-drop-nodrop";
                
                }
                
                if (PaletteDDHelper.currentMouseOverElementType !=null){ 

                	if (PaletteDDHelper.currentDraggedElementType.getDroppableOnElement().contains(PaletteDDHelper.currentMouseOverElementType)){
                	
                		icoCls = "x-tree-drop-ok-append";

                	}
                
                }
                
                return icoCls;
            }
            
            @Override
            public boolean notifyDrop(DragSource source, EventObject e,
            		DragData data) {
            	
                TreeDragData treeDragData 									= (TreeDragData) data;
                final TreeNode treeNode 									= treeDragData.getTreeNode();
                
                DiagramElementType elementType 								= (DiagramElementType) treeNode.getAttributeAsObject("DiagramElementType");
                
               // DiagramElementTypeInstantiationHandler instantiationHandler = (DiagramElementTypeInstantiationHandler) treeNode.getAttributeAsObject("InstantiationHander");
                
                assert(elementType!=null);
                
                int xCoordonate = e.getPageX()-getDrawingPanelTab().getAbsoluteLeft();
                // TODO OMG !! try to avoid that kind of constant definition here !!
                
                int yCoordonate = e.getPageY() - getDrawingPanelTab().getAbsoluteTop()-27; //27 is the height of the top tab switcher 

                
                if (PaletteDDHelper.currentDraggedElementType.isDroppableOnDrawingPanel()) {
                	getDrawingPanelTab().getCurrentDrawingPanel().getDDPaletteHander().dropOverDrawingPanel(elementType, xCoordonate, yCoordonate);
                }
                
                if (PaletteDDHelper.currentMouseOverElementType !=null){
                	
                	if (PaletteDDHelper.currentDraggedElementType.getDroppableOnElement().contains(PaletteDDHelper.currentMouseOverElementType)){
                		
                		DiagramElementInstance targetInstance = getDrawingPanelTab().getCurrentDrawingPanel().getElementInstanceById(PaletteDDHelper.currentMouseOverWidget.getElement().getId());
                		
                		assert(targetInstance!=null);
                		
                		DiagramElementInstance instance = getDrawingPanelTab().getCurrentDrawingPanel().getDDPaletteHander().dropOverElement((DiagramElementType)PaletteDDHelper.currentDraggedElementType, targetInstance, xCoordonate, yCoordonate);
                		
                		assert(instance!=null);
                		
                		DiagramElementTypeInstantiationHandler instantiationHandler = (DiagramElementTypeInstantiationHandler) treeNode.getAttributeAsObject("InstantiationHander");
                		
//                		//Apply the specific instantiation handler if one as been specified
//                		//(used in remote data loader palette)
                		if (instantiationHandler!=null){
                			instantiationHandler.onInstantiation(instance);
                		}
                		
                		for (DiagramElementTypeInstantiationHandler handler : instance.getElementType().getInstantiationHandlers()) {
							handler.onInstantiation(instance);
						}
                		
                		
                		
                	}
                	
                }
                
            	return super.notifyDrop(source, e, data);
            }
            
            
            


        };
		
	

        
	}
	
	public abstract void initGUI();
	
	@Override
	protected void onLoad() {
		
		this.initGUI();
		
		super.onLoad();
	}
	

	
	public DiagramView getCurrentView() {
		return currentView;
	}
	
	
	public void setCurrentView(DiagramView view){
		this.currentView = view;
	}
	
	
	public void displayComponentsInPosition(Panel panel,String positionName){
		
		for(DiagramComponent diagramComponent:getDesigner().getRegistry().getComponentByPosition(positionName)){
				
				diagramComponent.setDiagramLayout(this);
				
				Widget component = diagramComponent.getComponent();
				
				this.displayedComponents.put(diagramComponent, component);
				
				this.diaplayedComponentsParents.put(component, panel);
				
				if (!diagramComponent.isDisplayableOnView(currentView)){
					component.setVisible(false);
				}
				
				panel.add(component);

				
		}
	
	}
	
	
	public void setDesigner(Designer designer) {
		this.designer 		= designer;
	}
	
	public DrawingPanelTab getDrawingPanelTab() {
		return drawingPanelTab;
	}
	
	public Designer getDesigner() {
		return designer;
	}
	
	
	public void setDrawingPanelTab(DrawingPanelTab drawingPanelTab) {
		this.drawingPanelTab = drawingPanelTab;
	}
	
	public void displayDrawingPanelTab(Panel parentPanel){
		parentPanel.add(getDrawingPanelTab());
	}
	

	
	
	/**
	 * Replace a displayed component view by the one specified
	 * @param component
	 * @param wiget
	 */
	public void replaceComponentWidget(DiagramComponent component,Widget widget){
		
		//Replace old view by the new one
		Widget replaceMe 		=  this.displayedComponents.get(component);
	
		Panel parentPanel 		= (Panel) this.diaplayedComponentsParents.get(replaceMe);
		
		parentPanel.clear();
		
		parentPanel.add(widget);
		
		parentPanel.doLayout();
		
		//The new value is now the old one in case we would like to change it to
		this.displayedComponents.put(component,widget);
		
		this.diaplayedComponentsParents.put(widget, parentPanel);
		
	}
	
	
	/**
	 * Displays all components in the specified view <br>
	 * and hide all those who are'nt
	 * @param viewName
	 */
	public void switchToView(DiagramView view){
		
		//Only switch if we are not already in the specified view
		if (currentView.equals(view)==false){
			
				for(DiagramComponent diagramComponent:this.displayedComponents.keySet()){
						
						Widget currentComponent = this.displayedComponents.get(diagramComponent);
					
						if (diagramComponent.isDisplayableOnView(view) || diagramComponent.getViewsDisplayedOn().contains(new AllView())){
							
							currentComponent.setVisible(true);
							
						}else{
							
							currentComponent.setVisible(false);
							
						}
					
				}
			
			
		}
		
		this.currentView = view;
		this.doLayout();
	}
	

	public abstract void recompute();
	
}
