/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout;

import java.util.ArrayList;
import java.util.HashMap;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DrawingPanelTabListener;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.event.TabPanelListenerAdapter;

/**
 * 
 * @author nfleury
 *
 */
public class DrawingPanelTab extends TabPanel{
	
	private DrawingPanel currentDrawingPanel;
	
	private HashMap<String,DrawingPanel> diagrams = new HashMap<String,DrawingPanel>();
	
	private ArrayList<DrawingPanel> tabs = new ArrayList<DrawingPanel>();

	private DiagramLayout diagramLayout;
	
	private ArrayList<DrawingPanelTabListener> listeners = new ArrayList<DrawingPanelTabListener>();
	
	public DrawingPanelTab(DiagramLayout layout) {
		
		this.diagramLayout 	= layout;
		
		this.setAutoHeight(true);
		this.setAutoWidth(true);
		this.setBorder(false);
		this.setClosable(true);
		
		
		this.addListener(new TabPanelListenerAdapter(){
			
			@Override
			public void onTabChange(TabPanel source, Panel tab) {

				if (tab instanceof DrawingPanel){
						DrawingPanel currentD = (DrawingPanel) tab;
		
						currentDrawingPanel = currentD;
						
						for(DrawingPanelTabListener listener:listeners){
							listener.onTabChange(currentD);
						}
						
						super.onTabChange(source, tab);
				}		
			}
			
		});
		

		

		

	}
	
	
	public void addListener(DrawingPanelTabListener listener){
		listeners.add(listener);
	}
	


	public void addDrawingPanel(DrawingPanel drawingPanel){
		
		this.diagrams.put(drawingPanel.getSyntaxModel().getId(),drawingPanel);
		this.tabs.add(drawingPanel);
		this.currentDrawingPanel = drawingPanel;
		this.add(drawingPanel);

		this.activate(drawingPanel.getId());  
		//this.scrollToTab(drawingPanel, true);  


		this.doLayout();

		int myInnerW = getInnerWidth();
		int myInnerH = getInnerHeight();
		
		
		drawingPanel.getDrawingZone().setPixelSize(myInnerW, myInnerH);
		diagramLayout.recompute();


	}

	public HashMap<String, DrawingPanel> getDrawingPanels(){
		return diagrams;	
	}

	public DiagramLayout getDiagramLayout() {
		return this.diagramLayout;
	}
	
	
	public void removeDrawingPanel(DrawingPanel drawingPanel){
		this.diagrams.remove(drawingPanel);
		this.tabs.remove(drawingPanel);
		this.remove(drawingPanel);
	
	}
	
	public DrawingPanel getCurrentDrawingPanel(){
		return this.currentDrawingPanel;
	}
	
	
	public void updateDrawingZoneSize(int width, int height){
		this.doLayout();
		for (DrawingPanel panel : diagrams.values()) {
			panel.getDrawingZone().setPixelSize(width, height);
		}
	}

	
	
	public void activateDrawingPanelBySyntaxModelId(String id){
		
//		int i =0;
//		for(DrawingPanel p:diagrams.values()){
//			
//			assert(p.getSyntaxModel()!=null);
//			
//			if (p.getSyntaxModel().getId().equals(id)){
//				this.activate(i);
//			}
//			
//			i++;
//		}
		
		for(int i=0; i<tabs.size(); i++){
			DrawingPanel p = tabs.get(i);
			assert(p.getSyntaxModel()!=null);
			
			if (p.getSyntaxModel().getId().equals(id)){
				this.activate(i);
				break;
			}
		}
		
	}
	


	
	
}
