/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 
 */
package com.ebmwebsourcing.webdesigner.presentation.gwt.client.log;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;

/**
 * @author nfleury
 *
 */

public class PropertyChangedLogEntry extends AbstractLogEntry {
	
	
	private Object oldValue;
	private Object newValue;
	private DiagramProperty<?> subject;
	
	public PropertyChangedLogEntry(DiagramElementInstance elementInstance) {
		super(elementInstance);

	}

	
	public PropertyChangedLogEntry(DiagramElementInstance elementInstance, long time){
		super(elementInstance,time);
	}

	
	public PropertyChangedLogEntry(DiagramElementInstance elementInstance,DiagramProperty<?> subject,Object oldValue,Object newValue) {
		super(elementInstance);
		
		this.subject 	= subject;
		this.oldValue 	= oldValue;
		this.newValue 	= newValue;
		
	}

	
	public PropertyChangedLogEntry(DiagramElementInstance elementInstance, long time,DiagramProperty<?> subject,Object oldValue,Object newValue){
		super(elementInstance,time);
		this.subject 	= subject;
		this.oldValue 	= oldValue;
		this.newValue 	= newValue;
	}
	
	@Override
	public String getDescription() {

		return null;
	}
	
	
	
	@Override
	protected void redo() {
		//restore the new value
		getElementInstance().getElementModel().getPropertyByName(subject.getName()).setObjectValue(newValue,true);
	}

	@Override
	protected void undo() {
		//restore the old value
		getElementInstance().getElementModel().getPropertyByName(subject.getName()).setObjectValue(oldValue,false);

	}

}
