/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.log;

import java.util.ArrayList;

/**
 * List of AbstractLogEntry sorted by their time attribute. The first is the oldest. 
 * @author gcrosmarie
 *
 */
@SuppressWarnings("serial")
public class TimeSortedList extends ArrayList<AbstractLogEntry>{
	
	public TimeSortedList(){
		super();
	}
	
	public boolean add(AbstractLogEntry entry){
		int i = size()-1;
		long time = entry.getOccurenceTime();
		
		while(i>0 && time<get(i).getOccurenceTime()){
			i--;
		}
		
		add(i+1,entry);
		return true;
	}
	
	
}
