/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.log;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;
import com.gwtext.client.core.Function;
@SuppressWarnings("unused")
public class UpdateElementLogEntry extends AbstractLogEntry {
	

	private Function undoFunction;
	private Function redoFunction;
	
	public UpdateElementLogEntry(DiagramElementInstance elementInstance, Function undo, Function after){
		super(elementInstance);
		this.undoFunction = undo;
		this.redoFunction = after;
	}
	
	public UpdateElementLogEntry(DiagramElementInstance elementInstance, long time, Function undo, Function redo){
		super(elementInstance,time);
		this.undoFunction = undo;
		this.redoFunction = redo;
	}

	@Override
	public String getDescription() {
		return "Element updated at "+getOccurenceDate();
	}


	@Override
	protected void redo() {
		this.redoFunction.execute();
	}
	
	@Override
	protected void undo() {
		this.undoFunction.execute();
	}


	
	
}
