/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementInstance;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModel;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.gwtext.client.core.NameValuePair;

/**
 * This class is the base for the property system
 * It uses generics. A property system allows to define models containing custom properties.
 * 
 * @author enhan
 *
 * @param <T> The property value type
 */
public class DiagramProperty<T> implements HasValueAndDefaultValues<T>, HasValueChangeHandlers<T>{
	
	private String name;
	private DiagramElementInstance instance;
	private T value;
	private T defaultValue;
	private DiagramModel owner;
	// handler manager for GWT 2.0 style events (to avoid memory leaks)
	private HandlerManager handlerManager;
	
	/**
	 * Builds a DiagramProperty for a model. It's only a template.
	 * To create the property and assign it to a real DiagramElementInstance, see createNewInstanceOfProperty
	 * @param name the property name
	 * @param defaultValue a default value for the property (can't be null)
	 * @param owner the model where the property belongs
	 */
	public DiagramProperty(String name, T defaultValue, DiagramModel owner) {
		assert(defaultValue != null);
		assert(owner != null);
		this.name = name;
		this.value = defaultValue;
		this.defaultValue = defaultValue;
		this.owner = owner ;
	}
	
	// code inspired by Google (widget.java) to deal with handlers :D
	/**
	 * Adds this handler to the property.
	 * 
	 * @param <H>
	 *            the type of handler to add
	 * @param type
	 *            the event type
	 * @param handler
	 *            the handler
	 * @return {@link HandlerRegistration} used to remove the handler
	 */
	protected final <H extends EventHandler> HandlerRegistration addHandler(
			final H handler, GwtEvent.Type<H> type) {
		return ensureHandlers().addHandler(type, handler);
	}

	protected HandlerManager ensureHandlers() {
		return handlerManager == null ? handlerManager = new HandlerManager(
				this) : handlerManager;

	}
	
	public void fireEvent(GwtEvent<?> event) {
	    if (handlerManager != null) {
	      handlerManager.fireEvent(event);
	    }
	  }

	
	
	public String getName() {
		return name;
	}


	public DiagramElementInstance getElementInstance() {
		return instance;
	}
	
	// for compatibility  reasons...
	public NameValuePair getNameValuePair(){
		return new NameValuePair(name, value.toString());
	}

	public T getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(T v) {
		defaultValue = v;		
	}

	public T getValue() {
		return value;
	}
	
	@SuppressWarnings("unchecked")
	public void setObjectValue(Object value,boolean fireEvent){
		setValue((T)value, fireEvent);
	}
	
	public void setValue(final T arg0) {
				setValue(arg0, true) ;
	}

	@SuppressWarnings("unchecked")
	public void setValue(T arg0, boolean arg1) {
		if (arg0 != null && !arg0.equals(value)){

			
			if (instance!=null){
				T valueBefore = (T) PropertyHelper.getClonedValue(value);
				T valueAfter  = (T) PropertyHelper.getClonedValue(arg0);
				value = arg0;
			
				if (arg1){
					for(PropertyChangedHandler<T> handler:instance.getElementModel().getPropertyChangedHandlers()){
						handler.onChange(this,valueBefore,valueAfter);
					}
				}
				
			
			}
			
			value = arg0;
			
			if (arg1){
				ValueChangeEvent.fire(this, value);
			}
		}	
	}

	public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
		return addHandler(handler, ValueChangeEvent.getType());
	}
	
	public DiagramProperty<T> createNewInstanceOfProperty(DiagramElementInstance instance) {
		DiagramProperty<T> newInst = new DiagramProperty<T>(name, defaultValue,owner);
		newInst.instance = instance;		
		return newInst;
	}
	
	
	
	
	@SuppressWarnings("unchecked")
	public void copyPropertyValue(DiagramProperty<?> property){

			this.setValue((T)property.getValue(),false);

	}
	

	

	
	
}
