/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties;

import java.util.HashMap;

import com.gwtext.client.widgets.MessageBox;

public class PropertyHelper{

	private static HashMap<Class<?>, PropertyValueCloneHandler<?>> cloneHandlers = new HashMap<Class<?>, PropertyValueCloneHandler<?>>();
	
	//Register default Types
	static {
		
		registerPropertyValueCloneHandler(String.class, new PropertyValueCloneHandler<String>(){

			public String getClonedValue(Object value) {
				
				return new String((String)value);
			}

		});
		
		registerPropertyValueCloneHandler(Boolean.class, new PropertyValueCloneHandler<Boolean>(){

			public Boolean getClonedValue(Object value) {
				
				return new Boolean((Boolean)value);
			}

		});
		
		
		registerPropertyValueCloneHandler(Integer.class, new PropertyValueCloneHandler<Integer>(){

			public Integer getClonedValue(Object value) {
				
				return new Integer((String)value);
			}

		});

		
		
		
		
		
	}


	
	public static void registerPropertyValueCloneHandler(Class<?> clazz,PropertyValueCloneHandler<?> ph){
		cloneHandlers.put(clazz, ph);
	}
	
	public static Object getClonedValue(Object value){
		
		if (cloneHandlers.get(value.getClass())==null) MessageBox.alert("Clone handler for type:"+value.getClass()+" is not registered");
		
		return cloneHandlers.get(value.getClass()).getClonedValue(value);
		
	}
	
}
