/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.renderer;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.PaletteComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementGroup;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramElementType;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntax;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.diagram.syntax.DiagramSyntaxGroup;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.layout.AccordionLayout;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;

public class PaletteRenderer extends Renderer {
	
	private PaletteComponent paletteComponent;
	
	public PaletteRenderer() {
		super("DefaultPaletteRenderer");
		
	}

	public void setPaletteComponent(PaletteComponent paletteComponent) {
		this.paletteComponent = paletteComponent;
	}
	
	public PaletteComponent getPaletteComponent() {
		return paletteComponent;
	}
	
	@Override
	public Widget render(Object diagramSyntax) {
		
		DiagramSyntax syntax = (DiagramSyntax) diagramSyntax;
		
		Panel palettePanel = new Panel();
		
		palettePanel.setBorder(false);
		palettePanel.setBodyBorder(false);
		
		palettePanel.setTitle(paletteComponent.getName());  
		
        AccordionLayout accl = new AccordionLayout(true);
        
        accl.setFill(false);
        
        palettePanel.setLayout(accl);
		//For each Syntax group create a accordion layout panel
		for (DiagramSyntaxGroup syntaxGroup: syntax.getSyntaxGroups()){
			
	        Panel syntaxGroupPanel = new Panel();
	        syntaxGroupPanel.setTitle("<b>"+syntaxGroup.getName()+"</b>");

//	        AccordionLayout elementGroupLayout = new AccordionLayout(true);
//	        elementGroupLayout.setFill(false);
//	        
//	        
//	        
//	        syntaxGroupPanel.setLayout(elementGroupLayout);
	        
	        //for each diagram element group create accordion layout panel
	        for(DiagramElementGroup elementGroup:syntaxGroup.getElementGroups()){

		        Panel elementGroupPanel = new Panel("&nbsp;&nbsp;&nbsp;"+elementGroup.getName());
		        elementGroupPanel.setBorder(false);
		        
		        TreePanel elementGroupTree = new TreePanel();
		        
		        elementGroupTree.expand();
		        elementGroupPanel.expand();
		        
		        
		        elementGroupTree.setBorder(false);
		        
		        TreeNode root = new TreeNode();
		        root.setAllowDrop(false);
		        
		        //For each element type add a node
		        for(DiagramElementType elementType:elementGroup.getElementTypes()){
		        	
		        	TreeNode elementNode = new TreeNode(elementType.getName());
		        	
		        	elementNode.setAllowDrop(false);
		        	elementNode.setIcon(elementType.getIco());
		        	elementNode.setAttribute("DiagramElementType", elementType);
		        	
		        	root.appendChild(elementNode);
		        	
		        }
		        
		        elementGroupTree.setEnableDrop(false);
		        elementGroupTree.setEnableDD(true);
		        elementGroupTree.setRootNode(root);
		        elementGroupTree.setRootVisible(false);
		        elementGroupTree.setLines(false);
		        elementGroupTree.setDdGroup("diagramPanel");
		        
		        
		        elementGroupPanel.add(elementGroupTree);
		        
		        syntaxGroupPanel.add(elementGroupPanel);
		        
		     
		        
		        palettePanel.add(syntaxGroupPanel);	

	        	
	        	
	        }
			
			
		}

//        

//        

//        

//        
//        root.appendChild(poolNode);
//        
//        root.setExpanded(true);
//        
//        
//        palettePanel.add(panelOne);
        
		palettePanel.setAutoWidth(true);

		

		
		return palettePanel;
	}

}
