/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.renderer;

import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.DiagramModelGroup;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.DiagramProperty;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.metamodel.properties.editors.PropertyEditorFactory;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.NameValuePair;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.grid.GridEditor;
import com.gwtext.client.widgets.grid.GridView;
import com.gwtext.client.widgets.grid.PropertyGridPanel;


public class PropertyRenderer extends Renderer {
	
	
	
	
	public PropertyRenderer() {
		super("DefaultPropertyRenderer");
		
		
	}
	
	@Override
	public Widget render(Object modelToRender) {
		
		DiagramModel model = (DiagramModel) modelToRender;
		
		//for each model group create a tab
		TabPanel tabPanel = new TabPanel();  
		tabPanel.setBorder(false);  
		tabPanel.setActiveTab(0);  
		
		
		if (model !=null){
		
			  for(final DiagramModelGroup group:model.getModelGroups()){
				  
				  	Panel tab = new Panel(group.getName());
	
				  	
				   PropertyGridPanel grid = new PropertyGridPanel();  
			
				   grid.setNameText("Properties Grid");  
				  
				   //grid.setWidth("100%");
				 
				   grid.setAutoHeight(true);  
	//			   grid.setSorted(false);    
	//			   grid.setWidth(300);
				   
				   	GridView view = new GridView();
  
				  view.setAutoFill(true);
	
  
				   grid.setView(view);  
				   
				   NameValuePair[] source 	= new NameValuePair[group.getProperties().size()]; 
				   Map<String, GridEditor> customEditors 	= new HashMap<String, GridEditor>();
				   
				   for(int i =0;i<group.getProperties().size();i++){
					   
					   DiagramProperty<?> property = group.getProperties().get(i);
					   
					   	source[i] = property.getNameValuePair();
					   	customEditors.put(property.getName(),new GridEditor(PropertyEditorFactory.getEditorForProperty(property)));
				   
				   }
	
				   grid.setCustomEditors(customEditors);  
				   
				   grid.setSource(source);  
				
	
				   //add the properties to the tab;
				  	tab.add(grid);
				  	tabPanel.add(tab);
			  }
		
		}
		
		
		
		return tabPanel;
	}

}
