/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.presentation.gwt.client.renderer;

import java.util.ArrayList;

import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Function;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Tool;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;

/**
 * 
 * @author nfleury
 */
public class RemoteDataPaletteRenderer extends PaletteRenderer {
	

	private TreePanel tree;
	private RemoteDataLoader dataLoader;
	private Panel palettePanel;
	
	public RemoteDataPaletteRenderer(RemoteDataLoader dataLoader) {
		this.dataLoader = dataLoader;
	}

	

	
	@Override
	public Widget render(Object diagramSyntax) {
		
		this.palettePanel = new Panel(getPaletteComponent().getName());
		
		palettePanel.addTool(new Tool(Tool.REFRESH,new Function(){

			public void execute() {
				
				refresh();
				
			}
			
		}));
		

		refresh();
		
		return palettePanel;
	}
	
	private void refresh(){
		
		
		if (this.palettePanel.getEl() !=null){
			this.palettePanel.getEl().mask("Loading data, please wait ...", true);
		}
		
		if (this.tree != null){
			palettePanel.remove(this.tree);
			this.tree.removeFromParent();
			this.tree.destroy();
		}
		
		this.tree = new TreePanel();

	
		ArrayList<PaletteElement> pel = this.dataLoader.loadPaletteElements();
		
        TreeNode root = new TreeNode();
		
        //For each element type add a node
        for(PaletteElement e:pel){
        	
        	TreeNode elementNode = new TreeNode(e.getLabel()); 
        	
        	elementNode.setIcon(e.getType().getIco());
        	elementNode.setAttribute("DiagramElementType",e.getType());
        	elementNode.setAttribute("InstantiationHander",e.getInstantiationHandler());
        	root.appendChild(elementNode);
        	
        }
		
        tree.setRootNode(root);
   
		tree.setBorder(false);
		

        tree.setEnableDrop(false);
        tree.setEnableDD(true);
        tree.setRootVisible(false);
        tree.setLines(false);
        tree.setDdGroup("diagramPanel");
		
		palettePanel.add(tree);
        
        tree.doLayout();
        palettePanel.doLayout();
        
        if (this.palettePanel.getEl() !=null){
        	this.palettePanel.getEl().unmask();
        }

	
	}
	

}
