/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.server.service;

import gwtupload.server.UploadServlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

import com.ebmwebsourcing.webdesigner.business.domain.exception.SyntaxLoaderException;
import com.ebmwebsourcing.webdesigner.business.domain.exception.WebDesignerServiceException;
import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.rpc.WebDesignerService;
import com.ebmwebsourcing.webdesigner.server.syntaxloader.DiagramSyntaxLoader;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;

public class WebDesignerServiceImpl extends RemoteServiceServlet implements WebDesignerService{


	private static final long serialVersionUID = 1L;
	
	private static Logger logger = Logger.getLogger(WebDesignerServiceImpl.class);
	
	public static String UPLOAD_DIR = "upload";
	
	public SyntaxModel loadModelFromFile(String syntaxName,String version, String fileUrl, String fileFormat) throws WebDesignerServiceException {
		
		logger.debug("fileUrl:"+fileUrl);
		
	
		//- Case 1 - User has uploaded the file through the upload service
		//=> we retrieve the fileItem
		String showParam = URLHelper.init(fileUrl,"show");
		
		if (showParam !=null){
			


		Vector<FileItem> sessionFiles = (Vector<FileItem>) this.getThreadLocalRequest().getSession().getAttribute("FILES");
		 
		logger.debug("show param value:"+showParam);
		System.out.println("show param value:"+showParam);
		System.out.println("nb of session files:"+sessionFiles.size());
		FileItem file = UploadServlet.findFileItem(sessionFiles, showParam);

		System.out.println("file name:"+file.getName());
		System.out.println("file size:"+file.getSize());
		logger.debug("file name:"+file.getName());
		logger.debug("file size:"+file.getSize());


		try {
			
			DiagramSyntaxLoader loader 	= new DiagramSyntaxLoader(file);
			
			loader.setUploadPath(getAppRootPath());
			
			SyntaxModel model = loader.loadSyntaxModelFromFile(syntaxName, version, fileUrl, fileFormat);
			
			return model;
			
		} catch (SyntaxLoaderException e) {
			
			throw new WebDesignerServiceException(e.getMessage());
		}	
		
		
		
		//- Case 2 No upload - the fileURL was directly specified
		}else{
			
			try {
				
				File file = new File(fileUrl);
				
				DiagramSyntaxLoader loader 	= new DiagramSyntaxLoader(file);
				
				loader.setUploadPath(getAppRootPath());
				
				SyntaxModel model = loader.loadSyntaxModelFromFile(syntaxName, version, fileUrl, fileFormat);
				
				return model;
				
			} catch (SyntaxLoaderException e) {
				
				throw new WebDesignerServiceException(e.getMessage());
			}				
			
			
			
		}

	}
	
	
	public String uploadFile(String fileUrl,String uploadPath) throws WebDesignerServiceException{
		
		logger.debug("fileUrl:"+fileUrl);
		
	
		
		String showParam = URLHelper.init(fileUrl,"show");
		

		Vector<FileItem> sessionFiles = (Vector<FileItem>) this.getThreadLocalRequest().getSession().getAttribute("FILES");
		 
		logger.debug("show param value:"+showParam);
		System.out.println("show param value:"+showParam);
		System.out.println("nb of session files:"+sessionFiles.size());
		FileItem file = UploadServlet.findFileItem(sessionFiles, showParam);
		
		System.out.println("file name:"+file.getName());
		System.out.println("file size:"+file.getSize());
		logger.debug("file name:"+file.getName());
		logger.debug("file size:"+file.getSize());
		
		

		try {
			
			//first ensure that the upload path exists if not create it
	        File uploadDir = new File(getAppRootPath()+UPLOAD_DIR+File.separator+uploadPath+File.separator);
	        if (!(uploadDir.exists())) {
	
	            if (!(uploadDir.mkdir())) {
	                throw new WebDesignerServiceException("Can't create upload directory:"+getAppRootPath()+UPLOAD_DIR+File.separator+uploadPath+File.separator);
	            }
	
	        }
			
			File f=new File(getAppRootPath()+UPLOAD_DIR+File.separator+uploadPath+File.separator+file.getName());
			    
			InputStream inputStream = file.getInputStream();
			
		    OutputStream out=new FileOutputStream(f);
		    byte buf[]=new byte[1024];
		    int len;
		    while((len=inputStream.read(buf))>0)
		    out.write(buf,0,len);
		    out.close();
		    inputStream.close();
			
		} catch (IOException e) {
			
			e.printStackTrace();
			
			throw new WebDesignerServiceException("Error while creating file:"+file.getName());
			
		}

		
		
		
		return UPLOAD_DIR+"/"+uploadPath;
	}
	
	
	/**
	 * Return the upload directory path 
	 * 
	 * @return
	 * @throws WebDesignerServiceException 
	 */
	private String getAppRootPath() throws WebDesignerServiceException{
		
		ServletContext context 	= this.getThreadLocalRequest().getSession().getServletContext();
		
		String reqPath	 		= this.getThreadLocalRequest().getContextPath();	
		
		reqPath = reqPath.substring(reqPath.lastIndexOf("/") + 1);
		
		final String realContextPath = context.getRealPath(this.getThreadLocalRequest().getContextPath());
		
        final String rootPath = realContextPath.substring(0, realContextPath.lastIndexOf(reqPath));
		
        String result = rootPath ;
        
        //check if upload dir exists otherwise create it
        File uploadDir = new File(result+UPLOAD_DIR+File.separator);
        if (!(uploadDir.exists())) {

            if (!(uploadDir.mkdir())) {
            	
            	
                throw new WebDesignerServiceException("Can't create upload directory:"+result);
            }

        }

        
        return result;
	}
	
	
	  public static String getBaseUrl( HttpServletRequest request ) {
		    if ( ( request.getServerPort() == 80 ) ||
		         ( request.getServerPort() == 443 ) )
		      return request.getScheme() + "://" +
		             request.getServerName() +
		             request.getContextPath();
		    else
		      return request.getScheme() + "://" +
		             request.getServerName() + ":" + request.getServerPort() +
		             request.getContextPath();
	}
	
	
	public String createFileFromModel(SyntaxModel model, String syntaxName,String version, String fileFormat) throws WebDesignerServiceException {
	
		DiagramSyntaxLoader loader = new DiagramSyntaxLoader(model);
		
		loader.setUploadPath(getAppRootPath());
		
		String fileURL;
		
		
		try {
		
			fileURL = loader.loadFileURLFromModel(syntaxName,version,fileFormat);
		
			
			return getBaseUrl(getThreadLocalRequest())+fileURL;
			
		} catch (Throwable e) {
		
			throw new WebDesignerServiceException(e.getMessage());
		
		}

		

	}

}
