/**
 * Web Designer Framework - A simple framework for creating a web based designer - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webdesigner.server.syntaxloader;

import java.io.File;

import org.apache.commons.fileupload.FileItem;

import com.ebmwebsourcing.webdesigner.business.domain.syntaxloader.SyntaxModel;

/**
 * 
 * @author nfleury
 *
 */
public abstract class AbstractSyntaxFileToModelLoader {
	
	private SyntaxModel model;
	private FileItem fileItem;
	private String uploadPath;
	private File file;
	
	public void setFileItem(FileItem file){
		this.fileItem = file;
	}
	
	public FileItem getFileItem(){
		return this.fileItem;
	}
	
	public File getFile() {
		return file;
	}
	
	public void setFile(File file) {
		this.file = file;
	}
	
	public void setUploadPath(String uploadPath) {
		this.uploadPath = uploadPath;
	}
	
	public String getUploadPath() {
		return uploadPath;
	}
	
	public abstract SyntaxModel getModel() throws Exception;
	
	
	
	
}
