/**
 * diagram-interchange - Diagram Interchange Domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.AttributeExtension;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagram;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IStyle;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HasModelManager;

public abstract class DiagramElement implements IDiagramElement{
	

	private IStyle style;
	private IDiagramElement owningElement;
	private IModelElement modelElement;
	private LinkedHashSet<IDiagramElement> ownedElements;
	private IDiagram owningDiagram;
	private List<ObjectExtension> objectExtensions;
	private List<AttributeExtension> attributeExtensions;
	
	public DiagramElement() {
		this.ownedElements = new LinkedHashSet<IDiagramElement>();
		objectExtensions = new ArrayList<ObjectExtension>();
		attributeExtensions = new ArrayList<AttributeExtension>();
	}
	
	@Override
	public void addDiagramElement(IDiagramElement diagramElement) {
		this.ownedElements.add(diagramElement);
	}
	
	public void removeDiagramElement(IDiagramElement diagramElement){
		this.ownedElements.remove(diagramElement);
	}
	
	@Override
	public String getId() {
		return modelElement.getId();
	}



	@Override
	public LinkedHashSet<IDiagramElement> getOwnedElements() {
		return ownedElements;
	}

	@Override
	public IDiagramElement getOwningElement() {
		return owningElement;
	}



	@Override
	public IModelElement getModelElement() {
		return modelElement;
	}

	@Override
	public void copy(Object object) {
		DiagramElement other = (DiagramElement) object;
		
		
		this.ownedElements = new LinkedHashSet<IDiagramElement>(other.getOwnedElements());
		this.owningDiagram = other.getOwningDiagram();
		this.owningElement = other.getOwningElement();
		this.style = other.getStyle();
		

	}

	@Override
	public HasModelManager getClone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IDiagram getOwningDiagram() {
		return owningDiagram;
	}

	@Override
	public IStyle getStyle() {
		return style;
	}



	public void setModelElement(IModelElement modelElement) {
		this.modelElement = modelElement;
	}


	public void setStyle(IStyle style) {
		this.style = style;
	}

	public void setOwningElement(IDiagramElement owningElement) {
		this.owningElement = owningElement;
	}

	public void setOwnedElements(LinkedHashSet<IDiagramElement> ownedElements) {
		this.ownedElements = ownedElements;
	}

	public void setOwningDiagram(IDiagram owningDiagram) {
		this.owningDiagram = owningDiagram;
	}


	////////////////////////////////////////////
	/////                                  /////
	/////       	EXTENSIONS		       /////
	/////                                  /////
	////////////////////////////////////////////
	public void addObjectExtension(ObjectExtension obj){
		this.objectExtensions.add(obj);
	}
	
	public void removeObjectExtension(ObjectExtension obj){
		this.objectExtensions.remove(obj);
	}
	
	public void addAttributeExtension(AttributeExtension att){
		for(AttributeExtension a : attributeExtensions){
			if(a.hasSameErasure(att)){
				String qname = a.getAttributeQNameNS()+":"+a.getAttributeQNameLocalPart();
				throw new IllegalArgumentException(
						"This element ("+getId()+") already has an attribute with QName "+qname+".");
			}
		}
		this.attributeExtensions.add(att);
	}
	
	public void removeAttributeExtension(AttributeExtension att){
		this.attributeExtensions.remove(att);
	}
	
	public AttributeExtension getAttributeExtension(String ns, String lp){
		for(AttributeExtension att : attributeExtensions){
			if(att.getAttributeQNameNS().equals(ns) && att.getAttributeQNameLocalPart().equals(lp)){
				return att;
			}
		}
		return null;
	}
	
	public List<ObjectExtension> getObjectExtensions() {
		return objectExtensions;
	}

	public void setObjectExtensions(List<ObjectExtension> objectExtensions) {
		this.objectExtensions = objectExtensions;
	}

	public List<AttributeExtension> getAttributeExtensions() {
		return attributeExtensions;
	}

	public void setAttributeExtensions(
			List<AttributeExtension> attributeExtensions) {
		this.attributeExtensions = attributeExtensions;
	}
}
