/**
 * diagram-interchange - Diagram Interchange Domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagram;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IStyle;

public abstract class Diagram implements IDiagram{
	
	private String id;
	private String document;
	private String name;
	private IDiagramElement rootElement;
	private double resolution;
	private HashSet<IStyle> styles;
	
	public Diagram(){
		styles = new HashSet<IStyle>();
	}
	
	@Override
	public String getDocument() {
		return document;
	}
	
	public void setDocument(String document) {
		this.document = document;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public void setResolution(Float resolution) {
		this.resolution = resolution;
	}
	
	public void setRootElement(IDiagramElement rootElement) {
		this.rootElement = rootElement;
	}
	
	public void setStyles(HashSet<IStyle> styles) {
		this.styles = styles;
	}
	
	@Override
	public String getName() {
		return name;
	}
	
	/**
	 * Adds a diagram element to root element
	 * @param diagramElement
	 */
	public void addDiagramElement(IDiagramElement diagramElement){
		this.getRootElement().addDiagramElement(diagramElement);
	}
	
	@Override
	public double getResolution() {
		return resolution;
	}

	@Override
	public HashSet<IStyle> getStyles() {
		return styles;
	}

//	@Override
//	public void copy(Object object) {
//		Diagram other = (Diagram) object;
//		
//		this.id = new String(other.getId());
//		this.name = new String(other.getName());
//		this.resolution = new Double(other.getResolution());
//		if(other.getRootElement()!=null && rootElement!=null){
//			this.rootElement.copy(other.getRootElement()); 
//		}
//		if(other.getStyles()!=null){
//			this.styles = new HashSet<IStyle>(other.getStyles());
//		}
//	}
//
//	@Override
//	public HasModelManager getClone() {
//		return null;
//	}

	@Override
	public IDiagramElement getRootElement() {
		return this.rootElement;
	}

	@Override
	public void setResolution(double r) {
		this.resolution = r;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(String id) {
		this.id = id;
	}

}
